/***************************************************************************
                          filecombo.cpp  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev & Eric Laffoon <pdima@users.sourceforge.net,yshurik@penguinpowered.com,sequitur@easystreet.com>
                           (C) 2002-2003 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT includes
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>

// KDE includes
#include <tdelocale.h>
#include <tdefiledialog.h>
#include <kurl.h>

// app include
#include "filecombo.h"
#include "qextfileinfo.h"

FileCombo::FileCombo(const KURL& a_baseURL, TQWidget *parent, const char *name )
  :TQWidget(parent,name)
{
  baseURL = a_baseURL;
  m_absolutePath = false;

  TQHBoxLayout *layout = new TQHBoxLayout(this);

  combo   = new TQComboBox(true,this);
  combo->setEditable(true);
  button  = new TQPushButton(this);

  button  ->setFixedSize(35,25);
  button  ->setText(i18n("..."));

  layout  ->addWidget( combo );
  layout  ->addWidget( button );

  connect( button, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotFileSelect()) );
  connect( combo, TQ_SIGNAL(activated(const TQString&)), TQ_SLOT(slotComboActivated(const TQString&)));
  connect( combo, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(slotComboActivated(const TQString&)));
  setFocusProxy(combo);
}

FileCombo::FileCombo( TQWidget *parent, const char *name )
   :TQWidget( parent, name )
{
  baseURL.setPath(".");

  TQHBoxLayout *layout = new TQHBoxLayout(this);

  combo   = new TQComboBox(true,this);
  button  = new TQPushButton(this);

  button  ->setFixedSize(35,25);
  button  ->setText(i18n("..."));

  layout  ->addWidget( combo );
  layout  ->addWidget( button );

  connect( button, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotFileSelect()) );
  connect( combo, TQ_SIGNAL(activated(const TQString&)), TQ_SLOT(slotComboActivated(const TQString&)));
  connect( combo, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(slotComboActivated(const TQString&)));
  setFocusProxy(combo);
}

FileCombo::~FileCombo(){
}

TQString FileCombo::text() const
{
  return combo->currentText();
}

void FileCombo::setText( const TQString &_txt )
{
  combo ->setEditText( _txt );
}

void FileCombo::slotFileSelect()
{
  KFileDialog *dlg = new KFileDialog(baseURL.url(), i18n("*|All Files"), this, "", true);
  dlg->setMode(KFile::File | KFile::Directory | KFile::ExistingOnly);
  dlg->exec();
  KURL url = dlg->selectedURL();
  delete dlg;
  if ( !url.isEmpty() )
  {
    if (!m_absolutePath) url = QExtFileInfo::toRelative(url, baseURL);
    combo->setEditText( url.path() );
  }
}

/** No descriptions */
void FileCombo::setBaseURL(const KURL& a_baseURL)
{
 baseURL = a_baseURL;
}

/** No descriptions */
void FileCombo::setReturnAbsolutePath(bool absolutePath)
{
 m_absolutePath = absolutePath;
}

void FileCombo::slotComboActivated(const TQString&s)
{
  emit activated(s);
}

#include "filecombo.moc"
