/***************************************************************************
 *
 * tdenetman-openvpn.h - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_OPENVPN_H
#define TDENETWORKMANAGER_OPENVPN_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqlayout.h>
#include <tdeprocess.h>

#include "tdenetman-vpnplugin.h"
#include "openvpnprop.h"
#include "openvpnauth.h"

class OpenVPNPlugin : public VPNPlugin
{
	TQ_OBJECT
  
	public:
		OpenVPNPlugin(TQObject*, const char*, const TQStringList&);
		~OpenVPNPlugin();

		VPNConfigWidget* CreateConfigWidget(TQWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent=0);
};

class OpenVPNConnectionType
{
	public:
		enum CONNECTIONTYPE
		{
		  UNKNOWN = -1
		, X509 = 0
		, SHARED_KEY
		, PASSWORD
		, X509USERPASS
		};

		static CONNECTIONTYPE mapString2ConnectionType(TQString string);
		static TQString mapConnectionType2String(CONNECTIONTYPE connectionType);
};

class OpenVPNConfig : public VPNConfigWidget
{
	TQ_OBJECT
  
	public:
		void setVPNData(TDENetworkSingleRouteConfigurationList& routes, TDENetworkSettingsMap& properties, TDENetworkSettingsMap& secrets);
		TDENetworkSettingsMap getVPNProperties();
		TDENetworkSettingsMap getVPNSecrets();
		TDENetworkSingleRouteConfigurationList getVPNRoutes();
		bool hasChanged();
		bool isValid(TQStringList&);

		OpenVPNConfig(TQWidget* parent);
		~OpenVPNConfig();

	public slots:
		void receiveCipherData(TDEProcess*, char*, int);

	private:
		OpenVPNConfigWidget*   _openvpnWidget;

		void getCipherModes();
		TQString findOpenVPNBinary();

		TDENetworkSettingsMap m_vpnProperties;
		TDENetworkSettingsMap m_vpnSecrets;

	protected slots:
		void languageChange();
};

class OpenVPNAuthentication : public VPNAuthenticationWidget
{
	TQ_OBJECT
  
	public:
		OpenVPNAuthentication(TQWidget* parent = NULL, char* name = NULL);
		~OpenVPNAuthentication();
		void setVPNData(TDENetworkSingleRouteConfigurationList& routes, TDENetworkSettingsMap& properties, TDENetworkSettingsMap& secrets);
		TDENetworkSettingsMap getPasswords();
		void setPasswords(TDENetworkSettingsMap secrets);
		bool needsUserInteraction();

	private:
		OpenVPNAuthenticationWidget* _openvpnAuth;
		OpenVPNConnectionType::CONNECTIONTYPE _connectionType;
};

#endif /* TDENETWORKMANAGER_OPENVPN_H */
