//
// Copyright (C) 	2004	 Grzegorz Jaskiewicz <gj at pointblue.com.pl>
//
// gaducontactlist.cpp
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.
//

#ifndef GADUCONTACTLIST_H
#define GADUCONTACTLIST_H

#include <tqvaluelist.h>

class TQString;

class GaduContactsList
{
public:
	struct ContactLine {

		TQString displayname;
		TQString group;
		TQString uin;
		TQString firstname;
		TQString surname;
		TQString nickname;
		TQString phonenr;
		TQString email;
		bool 	ignored;
		bool 	offlineTo;
		TQString landline;
	};

	GaduContactsList();
	GaduContactsList( TQString );
	~GaduContactsList();
	TQString asString();
	void addContact( ContactLine &cl );
	void addContact(	TQString& displayname, TQString& group,
				TQString& uin, TQString& firstname,
				TQString& surname, TQString& nickname,
				TQString& phonenr, TQString& email,
				bool 	ignored, bool offlineTo,
				TQString& landline
	);
	unsigned int size();
	const GaduContactsList::ContactLine& operator[]( unsigned int i );
private:
	typedef TQValueList<ContactLine> CList;
	CList cList;
	CList::iterator	it;
};
#endif
