/*
 * kntsrcfilepropsdlg.cpp
 *
 * Copyright (c) 2001, 2002, 2003 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#include "kntsrcfilepropsdlg.h"
#include "kntsrcfilepropsdlgwidget.h"
#include "xmlnewsaccess.h"
#include "newsiconmgr.h"

#include <article.h>
#include <document.h>
#include <loader.h>

#include <tdeapplication.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <kurl.h>
#include <kurllabel.h>
#include <tdestandarddirs.h>
#include <tdeglobal.h>

#include <tqmultilineedit.h>
#include <tqvbox.h>

using namespace RSS;

class ArticleListBoxItem : public TQListBoxText
{
	public:
		ArticleListBoxItem( TQListBox *listbox, const Article &article );

		const Article &article() const { return m_article; }

	private:
		Article m_article;
};

ArticleListBoxItem::ArticleListBoxItem( TQListBox *listbox, const Article &article )
	: TQListBoxText( listbox ),
	m_article( article )
{
	setText( article.title() );
}

KntSrcFilePropsDlg::KntSrcFilePropsDlg(KPropertiesDialog *props)
	: KPropsDlgPlugin(props)
{
	m_child = new KntSrcFilePropsDlgWidget(properties->addVBoxPage(i18n("News Resource")));
	connect(m_child->urlName, TQ_SIGNAL(leftClickedURL(const TQString &)),
	        TQ_SLOT(slotOpenURL(const TQString &)));
	connect(m_child->lbArticles, TQ_SIGNAL(executed(TQListBoxItem *)),
	        TQ_SLOT(slotClickedArticle(TQListBoxItem *)));

	Loader *loader = Loader::create();
	connect(loader, TQ_SIGNAL(loadingComplete(Loader *, Document, Status)),
	        TQ_SLOT(slotConstructUI(Loader *, Document, Status)));
	loader->loadFrom(props->item()->url(), new FileRetriever);

	connect(NewsIconMgr::self(), TQ_SIGNAL(gotIcon(const KURL &, const TQPixmap &)),
	        TQ_SLOT(slotGotIcon(const KURL &, const TQPixmap &)));

	m_child->show();
}

void KntSrcFilePropsDlg::slotConstructUI(Loader *, Document doc, Status status)
{
	if (status != RSS::Success)
		return;

	KURL iconURL = doc.link();
	iconURL.setEncodedPathAndQuery(TQString::fromLatin1("/favicon.ico"));
	NewsIconMgr::self()->getIcon(iconURL);

	m_child->urlName->setText(doc.title());
	m_child->urlName->setURL(doc.link().url());

	m_child->mleDescription->setText(doc.description());

	Article::List::ConstIterator it = doc.articles().begin();
	Article::List::ConstIterator end = doc.articles().end();
	for (; it != end; ++it)
		new ArticleListBoxItem(m_child->lbArticles, *it);
}

void KntSrcFilePropsDlg::slotOpenURL(const TQString &url)
{
	tdeApp->invokeBrowser(url);
}

void KntSrcFilePropsDlg::slotGotIcon(const KURL &, const TQPixmap &pixmap)
{
	m_child->pixmapIcon->setPixmap(pixmap);
}

void KntSrcFilePropsDlg::slotClickedArticle(TQListBoxItem *item)
{
	ArticleListBoxItem *articleItem = static_cast<ArticleListBoxItem *>(item);
	slotOpenURL(articleItem->article().link().url());
}

TQObject *KntSrcFilePropsFactory::createObject(TQObject *parent, const char *,
		const char *classname, const TQStringList &)
{
	if (TQString::fromLatin1(classname) == "KPropsDlgPlugin")
	{
		if (!parent->inherits("KPropertiesDialog"))
			return 0L;

		TQObject *obj = new KntSrcFilePropsDlg(static_cast<KPropertiesDialog *>(parent));
		return obj;
	}
	return 0L;
}

extern "C"
{
	TDE_EXPORT void *init_libkntsrcfilepropsdlg()
	{
        TDEGlobal::locale()->insertCatalogue( "knewsticker" );
		return new KntSrcFilePropsFactory();
	}
}

#include "kntsrcfilepropsdlg.moc"
