/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: tdedocker.h,v 1.11 2005/02/09 03:32:26 cs19713 Exp $

#ifndef  _TDEDOCKER_H
#define  _TDEDOCKER_H

#include <tqtimer.h>
#include <tdeapplication.h>
#include <X11/Xlib.h>

class TrayLabelMgr;

class TDEDocker : public TDEApplication
{
  TQ_OBJECT

public:
  TDEDocker();

  TrayLabelMgr *trayLabelMgr(void) { return mTrayLabelMgr; }

  void dumpState(const TQString &file);

protected:
  bool x11EventFilter(XEvent * event);

private slots:
  void doInit();

private:
  void notifyPreviousInstance(Window prevInstance);

  Window mSelectionOwner;
  TrayLabelMgr *mTrayLabelMgr;
  TQTimer mInitTimer;
};

#endif //   _TDEDOCKER_H
