/***************************************************************************
    smb4kshareslistview  -  This is the shares list view of Smb4K.
                             -------------------
    begin                : Sa Jun 30 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESLISTVIEW_H
#define SMB4KSHARESLISTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <tdelistview.h>
#include <kurldrag.h>

// forward declarations
class Smb4KSharesListViewToolTip;

/**
 * This widget class provides the shares list view of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesListView : public TDEListView
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor
     *
     * @param parent        The parent widget
     *
     * @param name          The name of this object
     */
    Smb4KSharesListView( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KSharesListView();

    /**
     * Enumeration for the columns.
     */
#ifndef __FreeBSD__
    enum Columns { Item = 0,
                   Owner = 1,
                   Login = 2,
                   FileSystem = 3,
                   Free = 4,
                   Used = 5,
                   Total = 6,
                   Usage = 7 };
#else
    enum Columns { Item = 0,
                   Owner = 1,
                   FileSystem = 2,
                   Free = 3,
                   Used = 4,
                   Total = 5,
                   Usage = 6 };
#endif

    /**
     * Update the tool tip if it exists. This function just executes
     * Smb4KSharesListViewToolTip::update().
     */
    void updateToolTip();

  protected:
    /**
     * Reimplemented (sort of) from TQListView to enable dragging. As TQDragObject
     * a KURLDrag will be returned.
     *
     * @returns a KURLDrag object.
     */
    KURLDrag *dragObject();

    /**
     * Reimplemented from TQListView to allow some actions to be carried
     * out before the drag begins.
     */
    void startDrag();

    /**
     * Reimplemented from TQListView.
     */
    void contentsDragEnterEvent( TQDragEnterEvent * );

    /**
     * Reimplemented from TQListView.
     */
    void contentsDragMoveEvent( TQDragMoveEvent *e );

    /**
     * Reimplemented from TQListView.
     */
    void contentsDropEvent( TQDropEvent *e );

    /**
     * Reimplemented from TQListView. This function is used to
     * show the tooltips.
     */
    void contentsMouseMoveEvent( TQMouseEvent *e );

  protected slots:
    /**
     * This slot is connected to TDEListView::pressed() and clears the selection
     * if the user clicked on the viewport.
     *
     * @param item            The TQIconViewItem that the user clicked or NULL
     *                        if he/she pressed a mouse button on the viewport.
     */
    void slotPressed( TQListViewItem *item );

    /**
     * This slot shows the tool tip for an icon view item.
     */
    void slotShowToolTip();

  private:
    /**
     * The current global mouse position
     */
    TQPoint m_pos;

    /**
     * The tool tip
     */
    Smb4KSharesListViewToolTip *m_tooltip;
};

#endif

