# Copyright (c) 2004
#   Riverbank Computing Limited <info@riverbankcomputing.co.uk>
#   Jim Bublitz <jbublitz@nwinternet.com>
#
# This file is part of PyKDE.
#
# This copy of PyKDE is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
#
# PyKDE is supplied in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# PyKDE; see the file LICENSE.  If not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# This module is intended to be used by the configuration scripts of extension
# modules that %Import PyKDE modules.


import sip_tqt_config
from PyTQt import pytqtconfig


# These are installation specific values created when PyTQt was configured.
_pkg_config = {
    'dist_name':            '',
    'kde_version':          0x030503,
    'kde_version_extra':    'kde353',
    'kde_version_sfx':      '-kde353.diff',
    'kde_version_str':      '3.5.3',
    'tdebasedir':           '/opt/trinity',
    'kdeincdir':            '/opt/trinity/include',
    'kdelibdir':            '/opt/trinity/lib',
    'libdir':               'lib',
    'pytde_kde_sip_flags':  '-t ALL -x TQt_STYLE_WINDOWSXP -x TQt_STYLE_INTERLACE -x TQt_STYLE_WINDOWSXP -x TQt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t TQt_3_3_6 -t KDE_3_5_3',
    'pytde_mod_dir':        '/usr/lib/python2.5/site-packages',
    'pytde_modules':        'dcop tdecore tdefx tdeui tdeio tderesources tdeabc tdeutils tdefile tdeparts tdehtml tdespell tdeprint tdemdi',
    'pytde_sip_dir':        '/usr/share/sip-tqt',
    'pytde_version':        0x031000,
    'pytde_version_str':    '3.16.0'
}

_default_macros = None


class Configuration(pytqtconfig.Configuration):
    """The class that represents PyTQt configuration values.
    """
    def __init__(self, sub_cfg=None):
        """Initialise an instance of the class.

        sub_cfg is the list of sub-class configurations.  It should be None
        when called normally.
        """
        if sub_cfg:
            cfg = sub_cfg
        else:
            cfg = []

        cfg.append(_pkg_config)

        pytqtconfig.Configuration.__init__(self, cfg)


class DCOPModuleMakefile(pytqtconfig.TQtModuleMakefile):
    """The Makefile class for modules that %Import DCOP.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytde_mod_dir)
            self.LIBDIR.append(self.config.pytde_lib_dir)
            self.extra_libs.append(self.module_as_lib("DCOP"))

        pytqtconfig.TQtModuleMakefile.finalise(self)

class KdecoreModuleMakefile(DCOPModuleMakefile):
    """The Makefile class for modules that %Import tdecore.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdecore"))

        DCOPModuleMakefile.finalise(self)

class KdesuModuleMakefile(KdecoreModuleMakefile):
    """The Makefile class for modules that %Import tdesu.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdesu"))

        KdecoreModuleMakefile.finalise(self)

class KdefxModuleMakefile(KdecoreModuleMakefile):
    """The Makefile class for modules that %Import tdefx.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdefx"))

        KdecoreModuleMakefile.finalise(self)

class KdeuiModuleMakefile(KdefxModuleMakefile):
    """The Makefile class for modules that %Import tdeui.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdeui"))

        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("tqtxml"))

        KdefxModuleMakefile.finalise(self)

class KioModuleMakefile(KdeuiModuleMakefile):
    """The Makefile class for modules that %Import tdeio.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdeio"))

        KdeuiModuleMakefile.finalise(self)

class KfileModuleMakefile(KioModuleMakefile):
    """The Makefile class for modules that %Import tdefile.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdefile"))

        KioModuleMakefile.finalise(self)

class KpartsModuleMakefile(KfileModuleMakefile):
    """The Makefile class for modules that %Import tdeparts.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdeparts"))

        KfileModuleMakefile.finalise(self)

class KhtmlModuleMakefile(KpartsModuleMakefile):
    """The Makefile class for modules that %Import tdehtml.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdehtml"))

        KpartsModuleMakefile.finalise(self)

class KjsModuleMakefile(KhtmlModuleMakefile):
    """The Makefile class for modules that %Import kjs.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kjs"))

        KjsModuleMakefile.finalise(self)

class KdeprintModuleMakefile(KdeuiModuleMakefile):
    """The Makefile class for modules that %Import tdeprint.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pytqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("tdeprint"))

        KdeuiModuleMakefile.finalise(self)
