from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQ_SIGNAL, TQColor, TQSizePolicy, TQLabel
from tdecore import i18n
from tdeui import KPushButton, KGradientSelector, KTextEdit, KDualColorButton, KColorPatch

iconName = 'colors'
labelText = 'KGradientSelector'
docParts = ('tdeui', 'KGradientSelector')
helpText = ("An example of the KGradientSelector widget."
            "\n"
            "Change the start and finish colors with the dual color button."
            )


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.selector = KGradientSelector(self)
        self.dualLabel = TQLabel('Select Colors:', self)
        
        self.startColor = TQColor('red')
        self.finishColor = TQColor('blue')

        self.selector.setColors(self.startColor, self.finishColor)
        self.selector.setText('Start', 'Finish')
        
        self.dualButton = KDualColorButton(self.startColor, self.finishColor, self)
        self.dualButton.setSizePolicy(TQSizePolicy(TQSizePolicy.Maximum,
                                                  TQSizePolicy.Maximum))

        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help, 20)

        buttonLayout = TQHBoxLayout(layout, 4)
        buttonLayout.addWidget(self.dualLabel, 0)
        buttonLayout.addWidget(self.dualButton, 1)

        layout.addWidget(self.selector, 10)


        self.connect(self.dualButton, TQ_SIGNAL('fgChanged(const TQColor &)'),
                     self.selector.setFirstColor)
        self.connect(self.dualButton, TQ_SIGNAL('bgChanged(const TQColor &)'),
                     self.selector.setSecondColor)        
        self.connect(self.selector, TQ_SIGNAL('valueChanged(int)'),
                     self.updateValue)


    def updateValue(self, value):
        ## this should be extended to update a color swatch
        pass
