#ifndef _KVINOTIFIERWINDOWBODY_H_
#define _KVINOTIFIERWINDOWBODY_H_
//=============================================================================
//
//   File : kvinotifierwindowbody.h
//   Created on dom 02 gen 2005 17:53:29 by Iacopo Palazzi
//
//   This file is part of the KVIrc distribution
//   Copyright (C) 2005 Iacopo Palazzi < iakko(at)siena(dot)linux(dot)it >
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include <tqevent.h>
#include <tqrect.h>
#include <tqpoint.h>
#include <tqpixmap.h>

#include "notifiersettings.h"

/*
#ifdef QT3_SUPPORT
	#define TQPainter Q3Painter
#endif
*/

class TQPainter;

class KviNotifierWindowBody
{
public:
	KviNotifierWindowBody(TQRect r);
	~KviNotifierWindowBody();

// ================================
// Put members declaration below...
// ================================
private:
	TQRect 	m_rct;
	TQPoint	m_pnt;
	
	TQRect	m_textRect;
	
	TQRect	m_rctWriteIcon;
	TQRect	m_rctPrevIcon;
	TQRect	m_rctNextIcon;
	TQRect	m_rctCloseTabIcon;

	// Pictures
	TQPixmap	m_pixDX;
	TQPixmap	m_pixSX;
	TQPixmap	m_pixDWNSX;
	TQPixmap	m_pixDWNDX;
	TQPixmap	m_pixDWN;
	TQPixmap	m_pixKVIrcSX;
	TQPixmap	m_pixKVIrcDWN;
	TQPixmap	m_pixKVIrc;
	
	TQPixmap m_pixIconPrev;
	TQPixmap m_pixIconPrev_off;
	TQPixmap m_pixIconPrev_on;
	TQPixmap m_pixIconPrev_clicked;
	
	TQPixmap m_pixIconNext;
	TQPixmap m_pixIconNext_off;
	TQPixmap m_pixIconNext_on;
	TQPixmap m_pixIconNext_clicked;
	
	TQPixmap m_pixIconWrite;
	TQPixmap m_pixIconWrite_off;
	TQPixmap m_pixIconWrite_on;
	TQPixmap m_pixIconWrite_clicked;
	
	bool m_bNeedToRedraw;

	int m_prevIconState;
	int m_nextIconState;
	int m_writeIconState;

public:

protected:


// ================================
// Put methods declaration below...
// ================================
private:
	void loadImages();

public:
	void setWidth(int w);
	void setHeight(int h);
	void resize(int w, int h) { setWidth(w); setHeight(h); };
	void resize(TQRect r) { setWidth(r.width()); setHeight(r.height()); };
	void setPoint(int x, int y) { m_pnt.setX(x); m_pnt.setY(y); };

	void setPrevIcon(int state);
	void setNextIcon(int state);
	void setWriteIcon(int state);
	
	int nextIconState() { return m_nextIconState; };
	int prevIconState() { return m_prevIconState; };
	int writeIconState() { return m_writeIconState; };

	int x() { return m_pnt.x(); };
	int y() { return m_pnt.y(); };
	int width() { return m_rct.width(); };
	int height() { return m_rct.height(); };
	int baseLine() { return (y()+height()); };
	
	TQRect rect() { return m_rct; };
	TQRect textRect() { return m_textRect; };
	TQRect rctPrevIcon() { return m_rctPrevIcon; };
	TQRect rctNextIcon() { return m_rctNextIcon; };
	TQRect rctWriteIcon() { return m_rctWriteIcon; };

	void needToRedraw() { m_bNeedToRedraw = true; };

	void recalculatePositions();
	void touch() { m_bNeedToRedraw = true; };
	void draw(TQPainter *);
	
	void mouseMoveEvent(TQMouseEvent * e);
	void mousePressEvent(TQMouseEvent * e);
	void mouseReleaseEvent(TQMouseEvent * e);
	
	

protected:

};

#endif //!_KVINOTIFIERWINDOWBODY_H_
