/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef MICROSELECTWIDGET_H
#define MICROSELECTWIDGET_H

#include <tqgroupbox.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQGroupBox;
class TQLabel;
class KComboBox;

/**
@author David Saxton
*/
class MicroSelectWidget : public TQGroupBox
{
	TQ_OBJECT
  

	public:
		MicroSelectWidget( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~MicroSelectWidget();

		void setMicro( const TQString & id );
		TQString micro() const;
		
		/**
		 * @see MicroLibrary::microIDs
		 */
		void setAllowedAsmSet( unsigned allowed );
		/**
		 * @see MicroLibrary::microIDs
		 */
		void setAllowedGpsimSupport( unsigned allowed );
		/**
		 * @see MicroLibrary::microIDs
		 */
		void setAllowedFlowCodeSupport( unsigned allowed );
		/**
		 * @see MicroLibrary::microIDs
		 */
		void setAllowedMicrobeSupport( unsigned allowed );
		
	protected slots:
		void microFamilyChanged( const TQString & family );

	protected:
		void updateFromAllowed();
		
		unsigned int m_allowedAsmSet;
		unsigned int m_allowedGpsimSupport;
		unsigned int m_allowedFlowCodeSupport;
		unsigned int m_allowedMicrobeSupport;
		
		TQHBoxLayout * m_pWidgetLayout;
		TQLabel * m_pMicroFamilyLabel;
		KComboBox * m_pMicroFamily;
		TQLabel * m_pMicroLabel;
		KComboBox * m_pMicro;
};

#endif
