

//
// C++ Implementation: filterlogentry
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filterlogentry.h"

FilterLogEntry::FilterLogEntry()
{
  //set default values
  sentDateTime.setDate( TQDate( 2007, 11, 7 ) );
  sentDateTime.setTime( TQTime( 19, 05 ) );
  act = FActNone;
}

FilterLogEntry::FilterLogEntry( FilterAction_Type action, const TQDateTime& dateTime, const TQString& sender, const TQString& account, const TQString& subject, const TQString& mailbox)
  : act( action ), sentDateTime( dateTime ), sender( sender ), account( account ), subject( subject ), mailbox( mailbox )
{
}

FilterLogEntry::~FilterLogEntry()
{
}

void FilterLogEntry::print()
{
  TQString strAction;
  switch( act )
  {
    case FActPass       : strAction = "Passed"; break;
    case FActDelete     : strAction = "Deleted"; break;
    case FActMark       : strAction = "Marked"; break;
    case FActSpamcheck  : strAction = "forwarded to check for spam"; break;
    case FActMove       : strAction = TQString( "moved to %1" ).arg( mailbox); break;
    case FActNone       : strAction = "no Action (THIS IS AN ERROR!)"; break;
    default             : strAction = "ERROR! UNKNOWN ACTION"; break;
  }

  kdDebug() << sentDateTime.toString( TQt::LocalDate ) << ";" << account << ";" << sender << ";" << subject << ";" << strAction << endl;
}

FilterLogEntry::FilterLogEntry(const FilterLogEntry & ent)
{
  this->sentDateTime = ent.sentDateTime;
  this->account = ent.account;
  this->sender = ent.sender;
  this->subject = ent.subject;
  this->act = ent.act;
  this->mailbox = ent.mailbox;
}

FilterLogEntry& FilterLogEntry::operator=( const FilterLogEntry & ent )
{
  if( this == &ent ) return *this;

  this->sentDateTime = ent.sentDateTime;
  this->account = ent.account;
  this->sender = ent.sender;
  this->subject = ent.subject;
  this->mailbox = ent.mailbox;
  this->act = ent.act;

  return *this;
}

bool FilterLogEntry::isOlder( uint days )
{
  return sentDateTime.date().addDays( days ) < TQDate::currentDate();
}

bool FilterLogEntry::operator== ( const FilterLogEntry& ent ) const
{
  return sentDateTime == ent.sentDateTime;
}

bool FilterLogEntry::operator!=( const FilterLogEntry& ent ) const
{
  return sentDateTime != ent.sentDateTime;
}

bool FilterLogEntry::operator>( const FilterLogEntry& ent ) const
{
  return sentDateTime > ent.sentDateTime;
}

bool FilterLogEntry::operator>=( const FilterLogEntry& ent ) const
{
  return sentDateTime >= ent.sentDateTime;
}

bool FilterLogEntry::operator<( const FilterLogEntry& ent ) const
{
  return sentDateTime < ent.sentDateTime;
}

bool FilterLogEntry::operator<=( const FilterLogEntry & ent ) const
{
  return sentDateTime <= ent.sentDateTime;
}

void FilterLogEntry::save( TQDomDocument& doc, TQDomElement& parent )
{
  //create a new element and store the entry
  TQDomElement elem = doc.createElement( LOG_ENTRY_ELEMENT );
  elem.setAttribute( LOG_ENTRY_ATTRIBUTE_DATETIME, sentDateTime.toString( TQt::ISODate) );
  elem.setAttribute( LOG_ENTRY_ATTRIBUTE_SENDER, sender );
  elem.setAttribute( LOG_ENTRY_ATTRIBUTE_ACCOUNT, account );
  elem.setAttribute( LOG_ENTRY_ATTRIBUTE_SUBJECT, subject );

  //add entry element to the log (parent) element
  parent.appendChild( elem );
}

TQDateTime FilterLogEntry::getDate( )
{
  return sentDateTime;
}

TQString FilterLogEntry::getSender( )
{
  return sender;
}

TQString FilterLogEntry::getAccount( )
{
  return account;
}

TQString FilterLogEntry::getSubject( )
{
  return subject;
}

TQString FilterLogEntry::getMailbox( )
{
  return mailbox;
}
