/***************************************************************************
*   Copyright (C) 2003 by Unai Garro (ugarro@users.sourceforge.net)       *
*                                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef PANELDECO_H
#define PANELDECO_H


#include <tqevent.h>
#include <tqiconset.h>
#include <tqstring.h>
#include <tqhbox.h>
#include <tqpixmap.h>
#include <tqvbox.h>
#include <tqwidget.h>
#include <tqwidgetstack.h>


/**
* @author Unai Garro
*/

class PanelDeco;
class LeftDeco;
class TopDeco;

class PanelDeco : public TQVBox
{
	TQ_OBJECT
public:
	// Methods
	PanelDeco( TQWidget *parent = 0, const char *name = 0, const TQString &title = TQString::null, const TQString &iconName = TQString::null );
	~PanelDeco();
	int id( TQWidget* w ); // obtain the id of the given panel
	TQWidget* visiblePanel( void ); // obtain the current active panel no.

signals:
	void panelRaised( TQWidget *w, TQWidget *old_w );

private:
	TQHBox *hbox;
	LeftDeco *lDeco;
	TopDeco *tDeco;
	TQWidgetStack *stack;

public slots:
	void raise( TQWidget *w );
	void setHeader( const TQString &title = TQString::null, const TQString &icon = TQString::null );
protected:
	virtual void childEvent( TQChildEvent *e );


};

class LeftDeco: public TQWidget
{
	TQ_OBJECT
public:
	LeftDeco( TQWidget *parent = 0, const char *name = 0 );

	~LeftDeco();
};

class TopDeco: public TQWidget
{
	TQ_OBJECT
public:
	TopDeco( TQWidget *parent = 0, const char *name = 0, const TQString &title = TQString::null, const TQString &iconName = TQString::null );
	~TopDeco();
	virtual TQSize sizeHint( void );
public slots:
	void setHeader( const TQString &title = TQString::null, const TQString &iconName = TQString::null );
protected:
	virtual void paintEvent( TQPaintEvent *e );
private:
	TQPixmap *icon;
	TQString panelTitle;
};

#endif
