/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "datablocks/elementlist.h"

ElementList::ElementList() : TQValueList <Element>()
{}

ElementList::~ElementList()
{}

Element ElementList::getElement( int index ) const
{
	return * ( at( index ) );
}

Element ElementList::findByName( const TQString &name ) const
{
	ElementList::const_iterator it_end = end();
	for ( ElementList::const_iterator it = begin(); it != it_end; ++it ) {
		if ( ( *it ).name == name )
			return * it;
	}

	Element el;
	el.id = -1;
	return el;
}

Element ElementList::findByName( const TQRegExp &rx ) const
{
	ElementList::const_iterator it_end = end();
	for ( ElementList::const_iterator it = begin(); it != it_end; ++it ) {
		if ( ( *it ).name.find(rx) != -1 )
			return * it;
	}

	Element el;
	el.id = -1;
	return el;
}

bool ElementList::containsId( int id ) const // Search by id (which uses search by item, with comparison defined on header)
{
	if ( id == -1 ) {
		return count() == 0;
	}

	Element i;
	i.id = id;
	return ( find( i ) != end() );
}

bool ElementList::containsSubSet( ElementList &el )
{
	ElementList::const_iterator it_end = el.end();
	ElementList::const_iterator it;

	for ( it = el.begin(); it != it_end; ++it ) {
		if ( !containsId( ( *it ).id ) )
			return false;
	}
	return true;
}

TQString ElementList::join( const TQString &sep ) const
{
	TQString ret;

	ElementList::const_iterator it_end = end();
	ElementList::const_iterator it;

	for ( it = begin(); it != it_end; ++it ) {
		if ( it != begin() )
			ret += sep;
		ret += (*it).name;
	}

	return ret;
}

ElementList ElementList::split( const TQString &sep, const TQString &str )
{
	ElementList ret;
	TQStringList list = TQStringList::split(sep,str);

	TQStringList::const_iterator it_end = list.end();
	TQStringList::const_iterator it;

	for ( it = list.begin(); it != it_end; ++it ) {
		ret.append( Element((*it).stripWhiteSpace()) );
	}

	return ret;
}
