/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2006 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2006 Eike Hein <hein@kde.org>
*/

#ifndef AUTOREPLACECONFIG_H
#define AUTOREPLACECONFIG_H

#include <tqlistview.h>

#include "autoreplace_preferencesui.h"
#include "konvisettingspage.h"


class Autoreplace_Config : public Autoreplace_ConfigUI, public KonviSettingsPage
{
  TQ_OBJECT
  

  public:
    explicit Autoreplace_Config(TQWidget* parent, const char* name=NULL);
    ~Autoreplace_Config();

    virtual void saveSettings();
    virtual void loadSettings();
    virtual void restorePageToDefaults();

    virtual bool hasChanged();

  signals:
    void modified();

  protected slots:
    void entrySelected(TQListViewItem* autoreplaceEntry);
    void directionChanged(int newDirection);
    void patternChanged(const TQString& newPattern);
    void replacementChanged(const TQString& newReplacement);
    void addEntry();
    void removeEntry();
    void sort(int column);
    void disableSort();
    void showRegExpEditor();

  protected:
    void setAutoreplaceListView(const TQStringList &autoreplaceList);

    bool m_newItemSelected;

    TQStringList m_oldAutoreplaceList;
    TQStringList currentAutoreplaceList();
};

#endif
