/* This file is part of the KDE project
   Copyright (C) 2002, 2003 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXI_DRAGOBJECTS_H_
#define KEXI_DRAGOBJECTS_H_

#include <tqdragobject.h>

class TQString;
class TQStringList;
class TQWidget;

//! Drag object containing information about field(s).
class KEXICORE_EXPORT KexiFieldDrag : public TQStoredDrag
{
	public:
		/*! Creates drag object for a single field \a field. */
		KexiFieldDrag(const TQString& sourceMimeType, const TQString& sourceName, 
			const TQString& field, TQWidget *parent, const char *name);

		/*! Creates drag object for multiple fields \a fields. 
		 If there's less than two elements in the list, data is set up as for above ctor. */
		KexiFieldDrag(const TQString& sourceMimeType, const TQString& sourceName, 
			const TQStringList& field, TQWidget *parent=0, const char *name=0);

		~KexiFieldDrag();

		void addField(const TQString& field);

		/*! \return true if event \a e (of class TQDragMoveEvent or TQDropEvent)
		 can be decoded as "kexi/field" data */
		static bool canDecodeSingle( TQMimeSource* e );

		/*! \return true if event \a e (of class TQDragMoveEvent or TQDropEvent)
		 can be decoded as "kexi/fields" data. If decoding of "kexi/field" 
		 type is supported, decoding of "kexi/fields" is always supported. 
		 */
		static bool canDecodeMultiple( TQMimeSource* e );

		/*! Decodes data of single-field drag ("kexi/field" mime type) coming with event \a e. 
		 Sets \a sourceMimeType, \a sourceName and \a field. 
		 \return true on successful decoding (\a e will be accepted in such case). */
		static bool decodeSingle( TQDropEvent* e, TQString& sourceMimeType, 
			TQString& sourceName, TQString& field );

		/*! Decodes data of multiple-field drag ("kexi/fields" mime type) coming with event \a e. 
		 Sets \a sourceMimeType, \a sourceName and \a fields. Also works with "kexi/field" data.
		 \return true on successful decoding (\a e will be accepted in such case). */
		static bool decodeMultiple( TQDropEvent* e, TQString& sourceMimeType, 
			TQString& sourceName, TQStringList& fields );
};

class KEXICORE_EXPORT KexiDataProviderDrag : public TQStoredDrag
{
	public:
		KexiDataProviderDrag(const TQString& sourceMimeType, const TQString& sourceName, 
		TQWidget *parent=0, const char *name=0);
		~KexiDataProviderDrag() { };

		static bool canDecode( TQDragMoveEvent* e);
		static bool decode( TQDropEvent* e, TQString& sourceMimeType, TQString& sourceName);

};

#endif
