/*
   $Id$
*/

/****************************************************************************
 ** Copyright (C)  2001-2004 Klarlvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDGantt library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDGantt licenses may use this file in
 ** accordance with the KDGantt Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/Public/products/ for
 **   information about KDGantt Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 ** As a special exception, permission is given to link this program
 ** with any edition of TQt, and distribute the resulting executable,
 ** without including the source code for TQt in the source distribution.
 **
 **********************************************************************/

#ifndef KDGANTTMINIMIZESPLITTER_H
#define KDGANTTMINIMIZESPLITTER_H

#include "tqframe.h"
#include "tqvaluelist.h"

#ifndef TQT_NO_SPLITTER

class TQSplitterData;
class KDGanttSplitterLayoutStruct;

class KDGanttMinimizeSplitter : public TQFrame
{
    TQ_OBJECT
    
    TQ_ENUMS( Direction )
    TQ_PROPERTY( Orientation orientation READ orientation WRITE setOrientation )
    TQ_PROPERTY( Direction minimizeDirection READ minimizeDirection WRITE setMinimizeDirection )

public:
    enum ResizeMode { Stretch, KeepSize, FollowSizeHint };
    enum Direction { Left, Right, Up, Down };

    KDGanttMinimizeSplitter( TQWidget* parent=0, const char* name=0 );
    KDGanttMinimizeSplitter( Orientation, TQWidget* parent=0, const char* name=0 );
    ~KDGanttMinimizeSplitter();

    virtual void setOrientation( Orientation );
    Orientation orientation() const { return orient; }

    void setMinimizeDirection( Direction );
    Direction minimizeDirection() const;

    virtual void setResizeMode( TQWidget *w, ResizeMode );
    virtual void setOpaqueResize( bool = true );
    bool opaqueResize() const;

    void moveToFirst( TQWidget * );
    void moveToLast( TQWidget * );

    void refresh() { recalc( true ); }
    virtual TQSize sizeHint() const;
    virtual TQSize minimumSizeHint() const;

    TQValueList<int> sizes() const;
    void setSizes( TQValueList<int> );

    void expandPos( int id, int* min, int* max );
protected:
    void childEvent( TQChildEvent * );

    bool event( TQEvent * );
    void resizeEvent( TQResizeEvent * );

    int idAfter( TQWidget* ) const;

    void moveSplitter( TQCOORD pos, int id );
    virtual void drawSplitter( TQPainter*, TQCOORD x, TQCOORD y,
			       TQCOORD w, TQCOORD h );
    void styleChange( TQStyle& );
    int adjustPos( int , int );
    virtual void setRubberband( int );
    void getRange( int id, int*, int* );

private:
    void init();
    void recalc( bool update = false );
    void doResize();
    void storeSizes();
    void processChildEvents();
    KDGanttSplitterLayoutStruct *addWidget( TQWidget*, bool first = false );
    void recalcId();
    void moveBefore( int pos, int id, bool upLeft );
    void moveAfter( int pos, int id, bool upLeft );
    void setG( TQWidget *w, int p, int s, bool isSplitter = false );

    TQCOORD pick( const TQPoint &p ) const
    { return orient ==TQt::Horizontal ? p.x() : p.y(); }
    TQCOORD pick( const TQSize &s ) const
    { return orient ==TQt::Horizontal ? s.width() : s.height(); }

    TQCOORD trans( const TQPoint &p ) const
    { return orient ==TQt::Vertical ? p.x() : p.y(); }
    TQCOORD trans( const TQSize &s ) const
    { return orient ==TQt::Vertical ? s.width() : s.height(); }

    TQSplitterData *data;

private:
    Orientation orient;
    Direction _direction;
#ifndef DOXYGEN_SKIP_INTERNAL
    friend class KDGanttSplitterHandle;
#endif
private:	// Disabled copy constructor and operator=
#if defined(TQ_DISABLE_COPY)
    KDGanttMinimizeSplitter( const KDGanttMinimizeSplitter & );
    KDGanttMinimizeSplitter& operator=( const KDGanttMinimizeSplitter & );
#endif
};

#ifndef DOXYGEN_SKIP_INTERNAL
// This class was continued from a verbatim copy of the
// TQSplitterHandle pertaining to the TQt Enterprise License and the
// GPL. It has only been renamed to KDGanttSplitterHandler in order to
// avoid a symbol clash on some platforms.
class KDGanttSplitterHandle : public TQWidget
{
    TQ_OBJECT
  
public:
    KDGanttSplitterHandle( Orientation o,
		       KDGanttMinimizeSplitter *parent, const char* name=0 );
    void setOrientation( Orientation o );
    Orientation orientation() const { return orient; }

    bool opaque() const { return s->opaqueResize(); }

    TQSize sizeHint() const;

    int id() const { return myId; } // data->list.at(id())->wid == this
    void setId( int i ) { myId = i; }

protected:
    TQValueList<TQPointArray> buttonRegions();
    void paintEvent( TQPaintEvent * );
    void mouseMoveEvent( TQMouseEvent * );
    void mousePressEvent( TQMouseEvent * );
    void mouseReleaseEvent( TQMouseEvent * );
    int onButton( const TQPoint& p );
    void updateCursor( const TQPoint& p );

private:
    Orientation orient;
    bool opaq;
    int myId;

    KDGanttMinimizeSplitter *s;
    int _activeButton;
    bool _collapsed;
    int _origPos;
};
#endif

#endif // TQT_NO_SPLITTER

#endif // KDGANTTMINIMIZESPLITTER_H
