/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/


#include <tdeaboutdata.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdeinstance.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>
#include <ktrader.h>
#include <tdeparts/componentfactory.h>
#include <tdeparts/plugin.h>

#include "karbon_factory.h"
#include "karbon_part.h"
#include "karbon_resourceserver.h"
#include "karbon_aboutdata.h"
#include "karbon_tool_registry.h"

#include <kdebug.h>

KarbonResourceServer* KarbonFactory::s_rserver = 0;

TDEInstance* KarbonFactory::s_instance = 0L;
TDEAboutData* KarbonFactory::s_aboutData = 0L;

KarbonFactory::KarbonFactory( TQObject* parent, const char* name )
		: KoFactory( parent, name )
{
	instance();

	KarbonToolRegistry::instance();

	// Load plugins
	TDETrader::OfferList offers = TDETrader::self() -> query(TQString::fromLatin1("Karbon/CoreModule"),
                                    TQString::fromLatin1("Type == 'Service'"));

	TDETrader::OfferList::ConstIterator iter;

	for(iter = offers.begin(); iter != offers.end(); ++iter)
	{
		KService::Ptr service = *iter;
		int errCode = 0;
		KParts::Plugin* plugin =
		KParts::ComponentFactory::createInstanceFromService<KParts::Plugin> ( service, this, 0, TQStringList(), &errCode);
		if ( plugin )
			kdDebug() << "found plugin " << service -> property("Name").toString() << "\n";
	}
}

KarbonFactory::~KarbonFactory()
{
	delete s_instance;
	s_instance = 0L;
	delete s_aboutData;
	s_aboutData = 0L;
	delete s_rserver;
	s_rserver = 0L;
}

KParts::Part*
KarbonFactory::createPartObject( TQWidget* parentWidget, const char* widgetName,
								 TQObject* parent, const char* name, const char* classname, const TQStringList& )
{
	// If classname is "KoDocument", our host is a koffice application
	// otherwise, the host wants us as a simple part, so switch to readonly and
	// single view.
	bool bWantKoDocument = ( strcmp( classname, "KoDocument" ) == 0 );

	// parentWidget and widgetName are used by KoDocument for the
	// "readonly+singleView" case.
	KarbonPart* part =
		new KarbonPart( parentWidget, widgetName, parent, name, !bWantKoDocument );

	if( !bWantKoDocument )
		part->setReadWrite( false );

	return part;
}

TDEAboutData*
KarbonFactory::aboutData()
{
	if( !s_aboutData )
            s_aboutData = newKarbonAboutData();
	return s_aboutData;
}

TDEInstance*
KarbonFactory::instance()
{
	if( !s_instance )
	{
		s_instance = new TDEInstance( aboutData() );
		// Add any application-specific resource directories here

		s_instance->dirs()->addResourceType( "kis_brushes",
											  TDEStandardDirs::kde_default( "data" ) + "chalk/brushes/" );

		s_instance->dirs()->addResourceType( "kis_pattern",
											  TDEStandardDirs::kde_default( "data" ) + "chalk/patterns/" );

		s_instance->dirs()->addResourceType( "karbon_gradient",
											  TDEStandardDirs::kde_default( "data" ) + "karbon/gradients/" );

		s_instance->dirs()->addResourceType( "karbon_clipart",
											  TDEStandardDirs::kde_default( "data" ) + "karbon/cliparts/" );
		s_instance->dirs()->addResourceType( "karbon_template", TDEStandardDirs::kde_default("data") + "karbon/templates/" );
		// Tell the iconloader about share/apps/koffice/icons
		s_instance->iconLoader()->addAppDir("koffice");
	}

	return s_instance;
}

KarbonResourceServer *KarbonFactory::rServer()
{
	if( !s_rserver )
		s_rserver = new KarbonResourceServer;

	return s_rserver;
}

#include "karbon_factory.moc"

