//
// C++ Interface: kmfgenericinterfaceeditprotocol
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACEEDITPROTOCOL_H
#define KMFGENERICINTERFACEEDITPROTOCOL_H

#include "kmyfirewallgenericinterfaceeditprotocolwidget.h"

// TQt Includes
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqpixmap.h>
#include <tdemacros.h>

/**
@author Christian Hubinger
*/

class TQListViewItem;
class TQListBoxItem;

namespace KMF {
class KMFGenericDoc;
class KMFNetwork;
class KMFProtocol;
class KMFListViewItem;
class KMFProtocolCategory;

class TDE_EXPORT KMFGenericInterfaceEditProtocol : public KMyFirewallGenericInterfaceEditProtocolWidget {
	TQ_OBJECT
  
public:
	KMFGenericInterfaceEditProtocol( TQWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceEditProtocol();

	void saveProtocols();
	// void loadProtocols();
	
public slots:
	void slotUpdateView();

protected slots:
	void slotNewItemSelected( TQListViewItem* );
	void slotCurrentTCPPortChanged( TQListBoxItem * );
	void slotCurrentUDPPortChanged( TQListBoxItem * );
	void slotPortVauleChanged( int );
	void slotProtocolChanged();
	void slotNameDescritionChanged();
	void slotProtocolTypeChanged();
	void slotAddPort();
	void slotDelPort();
	void slotAddProtocol();
	void slotDelProtocol();
	void slotOnProtocolDeleleted( TQObject* );
public:
	void loadDoc( KMFNetwork* );

private: // Methods
	
	void updateEdit();
	const TQString& getXMLSniplet();
//	KMFProtocolCategory* getCuustomCategotry();
	
private: // DATA
	KMFNetwork *m_network;
	// TQPtrList<KMFProtocol> m_protocols;
	TQGuardedPtr<KMFProtocol> m_protocol;
	// bool m_protocolsLoaded;
	
};
}
#endif
