/***************************************************************************
begin                : Mon Jan 28 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/ 

#include "kmfpfinstaller.h"

// TQt includes
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqstring.h>
#include <tqmessagebox.h>
#include <tqfile.h>
#include <tqdir.h>
#include <tqtextstream.h>
#include <tqsizepolicy.h> 
//KDE includes
#include <kurl.h>
#include <tdestandarddirs.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdetempfile.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <tdeio/netaccess.h>
#include <ktar.h>
#include <kmdcodec.h>

// STD includes
// #include <iostream>

//My Includes
#include "../../version.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfconfig.h"
#include "../../core/kmferror.h"
#include "../../core/kmferrorhandler.h"
#include "../../core/kmftarget.h"
#include "../../core/kmftargetconfig.h"
#include "../../core/kmfnetzone.h"
#include "../../core/tdeprocesswrapper.h"
#include "../../core/kmfpluginfactory.h"
#include "../../core/kmfcompilerinterface.h"
#include "../../core/xmlnames.h"
#include "../../core/kmfgenericdoc.h"

#include "../../kmfwidgets/kmfprocout.h"
#include "../../kmfwidgets/kmfselectactivetarget.h"

namespace KMF {

KMFPFInstaller::KMFPFInstaller( TQObject* parent, const char* name ) :  KMFPlugin( parent, name ), KMFInstallerInterface() {
	m_err = new KMFError();
	m_osName = "openbsd";
	m_osGUIName = "OpenBSD";

/*	m_err_handler = new KMFErrorHandler( "KMFPFInstaller" );
	temp_file = new KTempFile();
	temp_file2 = new KTempFile();
	m_execWidget = 0;
	// m_tdesuCommand = Constants::KdeSu_Cmd + " -i kmyfirewall -d -c ";
	loadIcons();
	execWidget();*/
}

KMFPFInstaller::~KMFPFInstaller() {
/*	temp_file->close();
	temp_file2->close();
	temp_file->unlink();
	temp_file2->unlink();*/
}

KMFCompilerInterface* KMFPFInstaller::compiler() {
	if( ! rulesetDoc() || ! rulesetDoc()->target() ) {
		kdDebug() << "No Ruleset or Target available" << endl;
		return 0;
	}
	
	KMFCompilerInterface* compiler = rulesetDoc()->target()->compiler();
	if ( ! compiler ) {
		return 0;
	}
	return compiler;
}
TQValueList<KMFCompilerInterface*>*  KMFPFInstaller::compilers() {
	return KMFPluginFactory::CompilersForInstaller( osName() );
}

// void KMFPFInstaller::loadDoc( KMFIPTDoc *doc ) {
// // 	m_doc = doc;
// }

// void KMFPFInstaller::loadScript( const TQString& script ) {
// // 	m_script = script;
// }

// bool KMFPFInstaller::isLocalTarget() {
// 	if ( rulesetDoc() ) {
// 		return rulesetDoc()->target()->isLocalExecuteTarget();
// 	}
// 	return false;
// }

// void KMFPFInstaller::slotCloseWindow() {
// 	emit sigHideMe();
// }

KMFProcOut* KMFPFInstaller::execWidget(){
	if ( m_execWidget ) {
		m_execWidget->setText( "", "" );
		setOutputWidget( m_execWidget );
		return m_execWidget;
	}
	kdDebug() << "Need to create new execWidget." << endl;
	m_execWidget = new KMFProcOut( 0, "KMFProcOut" );
	connect( m_execWidget, TQ_SIGNAL( sigJobFinished( bool, const TQString& ) ),
		this, TQ_SLOT( slotJobFinished( bool, const TQString& ) ) );
	setOutputWidget( m_execWidget );
	return m_execWidget;
}


// void KMFPFInstaller::slotJobFinished( bool ok, const TQString& cmd_name ) {
// 	kdDebug() << "void KMFPFInstaller::slotJobFinished(bool ok,const TQString& cmd_name)" << endl;
// 	if ( cmd_name == Constants::InstallFirewallJob_Name && ok ) {  // installation successful
// 		const TQString & msg = i18n( "<p>Installation of the firewall finished successfully. "
// 		                            "The firewall will startup during the next reboot.<br>"
// 		                            "If you want the firewall to be started now click <b>OK</b> and then <b>Run Firewall</b>" );
// 		const TQString& cap = "Install Firewall";
// 		KMessageBox::information( 0, msg, cap );
// 
// 	} else if ( cmd_name == Constants::InstallFirewallJob_Name && !ok ) { // installation failed
// 		const TQString & msg = i18n( "<p><b>Installation of firewall failed</b><br>"
// 		                            "<p>Please make sure you are logged in as <b>root</b>" );
// 		const TQString& cap = "Install Firewall";
// 		KMessageBox::error( 0, msg, cap );
// 	} else if ( cmd_name == Constants::UninstallFirewallJob_Name && ok ) { // uninstallation successful
// 		const TQString & msg = i18n( "<p>Uninstallation of the firewall finished successfully. "
// 		                            "The firewall will no longer startup during boot.<br>"
// 		                            "If you want the firewall to be stopped now click <b>OK</b> and then <b>Stop Firewall</b>" );
// 		const TQString& cap = "Install Firewall";
// 		KMessageBox::information( 0, msg, cap );
// 	} else if ( cmd_name == Constants::UninstallFirewallJob_Name && !ok ) { // uninstallation failed
// 		const TQString & msg = i18n( "<p><b>Uninstallation of Firewall failed</b><br>"
// 		                            "Please make sure you are logged in as <b>root</b>" );
// 		const TQString& cap = "Uninstall Firewall";
// 		KMessageBox::error( 0, msg, cap );
// 	} /*else if ( !ok ) {
// 		const TQString & msg = i18n( "<p>Execution of <b>%1</b> failed"
// 		                            "<p>Click <b>OK</b> to check your configuration and make sure you are logged in as <b>root</b>" ).arg( cmd_name );
// 		const TQString& cap = "KMFPFInstaller";
// 		KMessageBox::error( 0, msg, cap );
// 	}*/
// 	emit sigStatusChanged();
// }








void KMFPFInstaller::cmdRunFW() {
// 	kdDebug() << "void KMFPFInstaller::slotRunFW()" << endl;
// 	loadScript( rulesetDoc()->compile() );
// 	const TQString file = temp_file->name();
// 	m_err = createFirewallScript( file );
// 	if ( ! m_err_handler->showError( m_err ) ) {
// 		return;
// 	}
// 	
// 	kdDebug() << "Starting Firewall..." << endl;
// 	
// 	if( rulesetDoc()->target()->isLocalExecuteTarget() ) {
// 		if (  KMessageBox::questionYesNo ( 0 , i18n( "<p><b>Are you sure you want to execute the generated iptables script?</b>"
// 	                                        "<p><b>A wrongly configured iptables script may make your computer unusable!</b>"
// 	                                        "<p>If your system hangs after you start the firewall, switch to a text "
// 	                                        "console (Ctrl+Alt+F1) and run the following commands to reset your iptables "
// 	                                        "configuration:"
// 	                                        "<p><ul>"
// 	                                        "<li>iptables -F </li>"
// 	                                        "<li>iptables -X </li>"
// 	                                        "<li>iptables -P INPUT ACCEPT </li>"
// 	                                        "<li>iptables -P OUTPUT ACCEPT </li>"
// 	                                        "<li>iptables -P FORWARD ACCEPT </li>"
// 	                                        "<li>iptables -t nat -F </li>"
// 	                                        "<li>iptables -t nat -X </li>"
// 	                                        "<li>iptables -t nat -P OUTPUT ACCEPT </li>"
// 	                                        "<li>iptables -t nat -P PREROUTING ACCEPT </li>"
// 	                                        "<li>iptables -t nat -P POSTROUTING ACCEPT </li>"
// 	                                        "<li>iptables -t mangle -F </li>"
// 	                                        "<li>iptables -t mangle -X </li>"
// 	                                        "<li>iptables -t mangle -P INPUT ACCEPT </li>"
// 	                                        "<li>iptables -t mangle -P OUTPUT ACCEPT </li>"
// 	                                        "<li>iptables -t mangle -P FORWARD ACCEPT </li>"
// 	                                        "<li>iptables -t mangle -P PREROUTING ACCEPT </li>"
// 	                                        "<li>iptables -t mangle -P POSTROUTING ACCEPT </li></ul>" ),
// 	                                        i18n( "Run Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_view_run_fw" ) != KMessageBox::Yes ) {
// 			return;
// 		}
// 		
// 		TQString cmd = "bash " + file + " -v start";
// 		// TDEProcessWrapper::instance()->slotStartLocalJob( "startfirewall", cmd, true, true );
// 		setOutputWidget( execWidget() );
// 		execWidget()->runCmd( cmd, Constants::StartFirewallJob_Name, i18n("Start Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() ), true );
// 		showOutput();
// 		checkStatus();
// 	} else {
// 		if(  KMessageBox::questionYesNo ( 0 , i18n( "<p><b>Are you sure you want to execute the generated firewall script on %1?</b>"
// 										"<p><b>A wrongly configured firewall script may make your computer unusable! PLease make sure that you have left the SSH port open, otherwise you will no longer be able to remote control the comuter using KMyFirewall or any other SSH client!</b></p>"
// 										"<p>If your system hangs after you start the firewall, switch to a text "
// 										"console (Ctrl+Alt+F1) and run the following commands to reset your iptables "
// 										"configuration:"
// 										"<p><ul>"
// 										"<li>iptables -F </li>"
// 										"<li>iptables -X </li>"
// 										"<li>iptables -P INPUT ACCEPT </li>"
// 										"<li>iptables -P OUTPUT ACCEPT </li>"
// 										"<li>iptables -P FORWARD ACCEPT </li>"
// 										"<li>iptables -t nat -F </li>"
// 										"<li>iptables -t nat -X </li>"
// 										"<li>iptables -t nat -P OUTPUT ACCEPT </li>"
// 										"<li>iptables -t nat -P PREROUTING ACCEPT </li>"
// 										"<li>iptables -t nat -P POSTROUTING ACCEPT </li>"
// 										"<li>iptables -t mangle -F </li>"
// 										"<li>iptables -t mangle -X </li>"
// 										"<li>iptables -t mangle -P INPUT ACCEPT </li>"
// 										"<li>iptables -t mangle -P OUTPUT ACCEPT </li>"
// 										"<li>iptables -t mangle -P FORWARD ACCEPT </li>"
// 										"<li>iptables -t mangle -P PREROUTING ACCEPT </li>"
// 										"<li>iptables -t mangle -P POSTROUTING ACCEPT </li></ul>" ).arg(rulesetDoc()->target()->toFriendlyString() ),
// 												i18n( "Install Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_run_fw_remote" ) != KMessageBox::Yes
// 												) {
// 				return;
// 			}
// 	
// 	
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( i18n("Please wait while the scripts are uploaded and executed..."), i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		
// 		generateInstallerPackage( rulesetDoc()->target() );
// 		TQString cmd = "cd /tmp/; sh ./kmfpackage.kmfpkg -q --start";
// 		TDEProcessWrapper::instance()->slotStartRemoteJob( Constants::StartFirewallJob_Name, cmd, rulesetDoc()->target() );
// 	
// 		if ( TDEProcessWrapper::instance()->exitStatus() != 0 ) {
// 			kdDebug() << "ERROR:" << TDEProcessWrapper::instance()->stdErr() << endl;
// 			KMessageBox::error( 0, TDEProcessWrapper::instance()->stdCombined() );
// 			return;	 
// 		}
// 			
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( TDEProcessWrapper::instance()->stdOut(), i18n("Start Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		checkStatus();
// 	}
// 	
}

void KMFPFInstaller::cmdStopFW() {
// 	kdDebug() << "Shutdown Firewall..." << endl;
// 	loadScript( rulesetDoc()->compile() );
// 	const TQString file = temp_file->name();
// 	m_err = createFirewallScript( file );
// 	if ( ! m_err_handler->showError( m_err ) ) {
// 		return;
// 	}
// 	
// 	if(  KMessageBox::questionYesNo ( 0 , i18n( "<p><b>Are you sure you want to stop the firewall on %1?</b>"
// 	                                        "<p><b>This will leave the computer unprotected!</b></p>" ).arg(rulesetDoc()->target()->toFriendlyString() ),
// 													i18n( "Install Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_stop_fw_remote" ) != KMessageBox::Yes
// 													) {
// 			return;
// 	};
// 	
// 	
// 	if( rulesetDoc()->target()->isLocalExecuteTarget() ) {
// 		
// 		TQString cmd = "bash " + file + " -v stop";
// 		setOutputWidget( execWidget() );
// 		execWidget()->runCmd( cmd, Constants::StopFirewallJob_Name, i18n("Stop Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() ), true );
// 		showOutput();
// 		checkStatus();
// 	
// 	} else {
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( i18n("Please wait while the scripts are uploaded and executed..."), i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		
// 		generateInstallerPackage( rulesetDoc()->target() );
// 		TQString cmd = "cd /tmp/; sh ./kmfpackage.kmfpkg -q --stop";
// 		TDEProcessWrapper::instance()->slotStartRemoteJob( Constants::StopFirewallJob_Name, cmd, rulesetDoc()->target() );
// 
// 		if ( TDEProcessWrapper::instance()->exitStatus() != 0 ) {
// 			kdDebug() << "ERROR:" << TDEProcessWrapper::instance()->stdErr() << endl;
// 			KMessageBox::error( 0, TDEProcessWrapper::instance()->stdCombined() );
// 			return;	 
// 		}
// 			
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( TDEProcessWrapper::instance()->stdOut(), i18n("Stop Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		checkStatus();
// 	}
}

void KMFPFInstaller::cmdShowRunningConfig( const TQString& para ) {
// 	TQString cmd = "";
// 	if ( para == Constants::FilterTable_Name ) {
// 		cmd = cmdShowFilter();
// 	} else if ( para == Constants::NatTable_Name ) {
// 		cmd = cmdShowNat();
// 	} else if ( para == Constants::MangleTable_Name ) {
// 		cmd = cmdShowMangle();
// 	} else {
// 		cmd = cmdShowAll();
// 	}
// 	
// 	if( rulesetDoc()->target()->isLocalExecuteTarget() ) {
// 		// TDEProcessWrapper::instance()->slotStartLocalJob( "show_config", cmd, true, true );
// 		setOutputWidget( execWidget() );
// 		execWidget()->runCmd( cmd,Constants::ShowConfigJob_Name,  i18n("Show Table %1 on %2").arg( para ).arg( rulesetDoc()->target()->toFriendlyString() ), true );
// 		showOutput();
// 		
// 	} else {
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( i18n("Please wait while the scripts are uploaded and executed..."), i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		TDEProcessWrapper::instance()->slotStartRemoteJob( Constants::ShowConfigJob_Name, cmd, rulesetDoc()->target() );
// 	
// 		if ( TDEProcessWrapper::instance()->exitStatus() != 0 ) {
// 			kdDebug() << "ERROR:" << TDEProcessWrapper::instance()->stdErr() << endl;
// 			KMessageBox::error( 0, TDEProcessWrapper::instance()->stdCombined() );
// 			return;	 
// 		}
// 		
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( TDEProcessWrapper::instance()->stdOut(), i18n("Show Table %1 on %2").arg( para ).arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 	}
}
// 


void KMFPFInstaller::cmdInstallFW() {
// 	kdDebug() << "KMFPFInstaller::slotInstallFW()" << endl;
// 	KMFTargetConfig *conf = rulesetDoc()->target()->config();	
// 	
// 	if(  KMessageBox::questionYesNo ( 0 , i18n( "<p><b>Are you sure you want to install the firewall on %1?</b>"
// 	                                        "<p>This will add the scripts to your init system that are required to "
// 	                                        "start your firewall during bootup."
// 	                                        "<p><b>Please make sure that the firewall runs properly before you install it.</b>" ).arg( rulesetDoc()->target()->toFriendlyString() ),
// 	                                        i18n( "Install Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_view_install_fw" ) != KMessageBox::Yes ) {
// 		return;
// 	}
// 	
// 	if ( rulesetDoc()->target()->isLocalExecuteTarget() ) {
// 		KURL url ( TDEGlobal::dirs() ->findResource( "appdata", "scripts/installer/linux/kmfinstall.sh" ));
// 		TQString installscript = url.path();
// 
// 		if ( installscript.isEmpty() ) {
// 			TQString msg = i18n( "<p>Unable to find install script <b>kmfinstall.sh</b>"
// 			                    "<p>Please check your installation. Usually this script is installed in "
// 			                    "$TDEDIR/share/apps/kmyfirewall/scripts/installer/linux"
// 			                    "<p>Unable to install the firewall without this script." );
// 			TQString cap = "KMFPFInstaller";
// 			KMessageBox::error( 0, msg, cap );
// 			return;
// 		}
// 		kdDebug() << "found Install script: " << installscript << endl;
// 		if ( conf->oS() == "linux" && conf->distribution() == "gentoo" ) {
// 			TQString msg = i18n( "<p>The following files will be created by installing the firewall"
// 			                    "<ul><li>Directory: %1</li>"
// 			                    "<li>File: %2</li>"
// 			                    "<li>File: %3</li>"
// 			                    "<li>Link: %4 -&gt; %5</li></ul></ul>" )
// 			              .arg( "/etc/kmyfirewall" )
// 			              .arg( "/etc/kmyfirewall/kmyfirewall.sh" )
// 			              .arg( conf->IPTPath() + "/kmyfirewall" )
// 			              .arg( conf->rcDefaultPath() + "/kmyfirewall" )
// 			              .arg( conf->initPath() + "/kmyfirewall" );
// 			TQString cap = i18n( "Install Firewall" );
// 			KMessageBox::information( 0, msg, cap, "created_install_files", 0 );
// 		} else if ( conf->oS() == "linux"  ) {
// 			TQString msg = i18n( "<p>The following files will be created by installing the firewall"
// 			                    "<ul><li>Directory: %1</li>"
// 			                    "<li>File: %2</li>"
// 			                    "<li>File: %3</li>"
// 			                    "<li>Link: %4 -&gt; %5</li>"
// 			                    "<li>Link: %6 -&gt; %7</li></ul></ul>" )
// 			              .arg( "/etc/kmyfirewall" )
// 			              .arg( "/etc/kmyfirewall/kmyfirewall.sh" )
// 			              .arg( conf->initPath() + "/kmyfirewall" )
// 			              .arg( conf->rcDefaultPath() + "/S99kmyfirewall" )
// 			              .arg( conf->initPath() + "/kmyfirewall" )
// 			              .arg( conf->rcDefaultPath() + "/K01kmyfirewall" )
// 			              .arg( conf->initPath() + "/kmyfirewall" );
// 			TQString cap = i18n( "Install Firewall" );
// 			KMessageBox::information( 0, msg, cap, "created_install_files", 0 );
// 		}
// 
// 		const TQString fwscript = temp_file->name();
// 		m_err = createFirewallScript( fwscript );
// 		if ( ! m_err_handler->showError( m_err ) ) {
// 			return;
// 		}
// 		const TQString initscript = temp_file2->name();
// 		m_err = createInitScript( initscript, KMFConfig::distribution() );
// 		if ( ! m_err_handler->showError( m_err ) ) {
// 			return;
// 		}
// 		TQString systemtype;
// 		if ( conf->distribution() == "gentoo" )
// 			systemtype = "gentoo";
// 		else if( conf->distribution() == "slackware" )
// 			systemtype = "slackware";
// 		else
// 			systemtype = "sysv";
// 
// 		TQString cmd = "bash " + installscript + " install " + systemtype + " " + conf->initPath() + " " + conf->rcDefaultPath() + " " + initscript + " " + fwscript;
// 	//	TDEProcessWrapper::instance()->slotStartLocalJob( "installfirewall", cmd, true, true );
// 		
// 		setOutputWidget( execWidget() );
// 		execWidget()->runCmd( cmd, Constants::InstallFirewallJob_Name, i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() ), true );
// 		showOutput();
// 		checkStatus();
// 	} else {
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( i18n("Please wait while the scripts are uploaded and executed..."), i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();	
// 			
// 		generateInstallerPackage( rulesetDoc()->target() );
// 		TQString cmd = "cd /tmp/; sh ./kmfpackage.kmfpkg -q --install";
// 		TDEProcessWrapper::instance()->slotStartRemoteJob( Constants::InstallFirewallJob_Name, cmd, rulesetDoc()->target() );
// 	
// 		if ( TDEProcessWrapper::instance()->exitStatus() != 0 ) {
// 			kdDebug() << "ERROR:" << TDEProcessWrapper::instance()->stdErr() << endl;
// 			KMessageBox::error( 0, TDEProcessWrapper::instance()->stdCombined() );
// 			return;	 
// 		}
// 		
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( TDEProcessWrapper::instance()->stdOut(), i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		checkStatus();	
// 	}
// 	
}

void KMFPFInstaller::cmdUninstallFW() {
// 	kdDebug() << "KMFPFInstaller::slotUninstallFW()" << endl;
// 	
// 	KMFTargetConfig *conf = rulesetDoc()->target()->config();	
// 	
// 	if (  KMessageBox::questionYesNo ( 0 , i18n( "<p><b>Are you sure you want to uninstall the firewall from %1?</b><br>"
// 	                                        "The firewall will no longer start up during boot." ).arg( rulesetDoc()->target()->toFriendlyString() ),
// 	                                        i18n( "Uninstall Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_view_uninstall_fw" ) != KMessageBox::Yes ) {
// 		return;
// 	}
// 		
// 		
// 	if ( rulesetDoc()->target()->isLocalExecuteTarget() ) {
// 		KURL url (TDEGlobal::dirs() ->findResource( "appdata", "scripts/installer/linux/kmfinstall.sh" ));
// 		TQString installscript = url.path();
// 
// 		if ( installscript.isEmpty() ) {
// 			const TQString & msg = i18n( "<p>Unable to find uninstall script <b>kmfinstall.sh</b>"
// 			                            "<p>Please check your installation. Usually this script is installed in "
// 			                            "$TDEDIR/share/apps/kmyfirewall/scripts/installer/linux"
// 			                            "<p>Unable to uninstall the firewall without this script." );
// 			const TQString& cap = "KMFPFInstaller";
// 			KMessageBox::error( 0, msg, cap );
// 			return;
// 		}
// 		kdDebug() << "found Install script: " << installscript << endl;
// 		if ( conf->oS() == "linux" &&  conf->distribution() == "gentoo" ) {
// 			TQString msg = i18n( "<p>The following files will be removed by uninstalling the firewall"
// 			                    "<ul><li>Directory: %1</li>"
// 			                    "<li>File: %2</li>"
// 			                    "<li>File: %3</li>"
// 			                    "<li>Link: %4 -&gt; %5</li></ul></ul>" )
// 			              .arg( "/etc/kmyfirewall" )
// 			              .arg( "/etc/kmyfirewall/kmyfirewall.sh" )
// 			              .arg( conf->initPath() + "/kmyfirewall" )
// 			              .arg( conf->rcDefaultPath() + "/kmyfirewall" )
// 			              .arg( conf->initPath() + "/kmyfirewall" );
// 			TQString cap = i18n( "Uninstall Firewall" );
// 			KMessageBox::information( 0, msg, cap, "removed_uninstall_files", 0 );
// 		} else if ( conf->oS() == "linux" ) {
// 			TQString msg = i18n( "<p>The following files will be removed by uninstalling the firewall"
// 			                    "<ul><li>Directory: %1</li>"
// 			                    "<li>File: %2</li>"
// 			                    "<li>File: %3</li>"
// 			                    "<li>Link: %4 -&gt; %5</li>"
// 			                    "<li>Link: %6 -&gt; %7</li></ul></ul>" )
// 			              .arg( "/etc/kmyfirewall" )
// 			              .arg( "/etc/kmyfirewall/kmyfirewall.sh" )
// 			              .arg( conf->initPath() + "/kmyfirewall" )
// 			              .arg( conf->rcDefaultPath() + "/S99kmyfirewall" )
// 			              .arg( conf->initPath() + "/kmyfirewall" )
// 			              .arg( conf->rcDefaultPath() + "/K01kmyfirewall" )
// 			              .arg( conf->initPath() + "/kmyfirewall" );
// 			TQString cap = i18n( "Uninstall Firewall" );
// 			KMessageBox::information( 0, msg, cap, "removed_uninstall_files", 0 );
// 		}
// 
// 		TQString systemtype;
// 		if ( conf->distribution() == "gentoo" )
// 			systemtype = "gentoo";
// 		else if( conf->distribution() == "slackware" )
// 			systemtype = "slackware";
// 		else
// 			systemtype = "sysv";
// 
// 		TQString cmd = "bash " + installscript + " uninstall " + systemtype + " " + conf->initPath() + " " + conf->rcDefaultPath();
// 		// TDEProcessWrapper::instance()->slotStartLocalJob( "uninstallfirewall", cmd, true, true );
// 	
// 		setOutputWidget( execWidget() );
// 		execWidget()->runCmd( cmd, Constants::UninstallFirewallJob_Name,  i18n("Uninstall Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() ), true );
// 		showOutput();
// 		checkStatus();
// 	
// 	} else {
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( i18n("Please wait while the scripts are uploaded and executed..."), i18n("Install Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();	
// 			
// 		generateInstallerPackage( rulesetDoc()->target() );
// 		TQString cmd = "cd /tmp/; sh ./kmfpackage.kmfpkg -q --uninstall";
// 		TDEProcessWrapper::instance()->slotStartRemoteJob( Constants::UninstallFirewallJob_Name, cmd, rulesetDoc()->target() );
// 		
// 		if ( TDEProcessWrapper::instance()->exitStatus() != 0 ) {
// 			kdDebug() << "ERROR:" << TDEProcessWrapper::instance()->stdErr() << endl;
// 			KMessageBox::error( 0, TDEProcessWrapper::instance()->stdCombined() );
// 			return;	 
// 		}
// 		
// 		setOutputWidget( execWidget() );
// 		execWidget()->setText( TDEProcessWrapper::instance()->stdOut(), i18n("Uninstall Firewall on %1").arg( rulesetDoc()->target()->toFriendlyString() )  );
// 		showOutput();
// 		checkStatus();
// 	}	
// 		
// 	
}



// TQString KMFPFInstaller::cmdShowAll() {
// 	kdDebug() << "Show Config..." << endl;
// 	
// 	KMFTargetConfig *conf = rulesetDoc()->target()->config();
// 	
// 	TQString show_config = " echo Config of Table FILTER:; "
// 	                      "echo;" +
// 	                      conf->IPTPath()  + " -L -v -n; "
// 	                      "echo;"
// 	                      "echo;"
// 	                      "echo Config of Table NAT:; "
// 	                      "echo;" +
// 	                      conf->IPTPath() + " -t nat -L  -v -n; "
// 	                      "echo;"
// 	                      "echo;"
// 	                      "echo Config of Table MANGLE:; "
// 	                      "echo;" +
// 	                      conf->IPTPath() + " -t mangle -L -v -n ";
// 	TQString cmd_name = conf->IPTPath() + " -L -v -n; " + conf->IPTPath() + " -t nat -L -v -n; " + conf->IPTPath() + " -t mangle -L -v -n";
// 	return show_config;
// }

// TQString KMFPFInstaller::cmdShowFilter() {
// 	kdDebug() << "Show Config..." << endl;
// 	KMFTargetConfig *conf = rulesetDoc()->target()->config();
// 	
// 	kdDebug() << "iptables" << " -t filter -L" << endl;
// 	TQString show_config = " echo Config of Table FILTER:; "
// 	                      "echo; " +
// 	                      conf->IPTPath() + " -t filter -L -v -n";
// 	return show_config;
// }

// TQString KMFPFInstaller::cmdShowNat() {
// 	kdDebug() << "Show Config..." << endl;
// 	KMFTargetConfig *conf = rulesetDoc()->target()->config();
// 	
// 	kdDebug() << "iptables" << " -t nat -L -v -n" << endl;
// 	TQString show_config = " echo Config of Table NAT:;"
// 	                      "echo;" +
// 	                        conf->IPTPath() +" -t nat -L  -v -n";
// 	return show_config;
// }

// TQString KMFPFInstaller::cmdShowMangle() {
// 	kdDebug() << "Show Config..." << endl;
// 	
// 	KMFTargetConfig *conf = rulesetDoc()->target()->config();
// 	
// 	kdDebug() << "iptables" << " -t mangle -L" << endl;
// 	TQString show_config = " echo Config of Table MANGLE:;"
// 	                      "echo;" +
// 	                       conf->IPTPath() + " -t mangle -L  -v -n";
// 	return show_config;
// }







// KMFError* KMFPFInstaller::createInitScript( const TQString& initfile, const TQString& systemtype ) {
// 	if ( !initfile || initfile.isEmpty() ) {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "No filename given for script creation." );
// 		m_err->setErrMsg( msg );
// 		return m_err;
// 	}
// 
// 	// 	kdDebug() << "Writing script to file " << initfile << endl;
// 	TQFile f( initfile );
// 	f.remove();
// 	bool gotit = f.open( IO_ReadWrite );
// 	if ( gotit ) {
// 		TQTextStream ts( &f );
// 		//Header
// 		TQString version = KMYFIREWALL_VERSION;
// 		TQString copyright_string = COPYRIGHT_STRING;
// 		TQString maintainer = MAINTAINER;
// 		TQString s;
// 		if ( systemtype == "gentoo" ) {
// 			kdDebug() << "Writing Gentoo init script." << endl;
// 			s = "#!/sbin/runscript\n"
// 			    "#\n"
// 			    "# " + copyright_string + "\n"
// 			    "# 	mail to: " + maintainer + "\n"
// 			    "#\n"
// 			    "# Gentoo Start/Stop script for KMyFirewall " + version + "\n"
// 			    "# This is an automatic generated file DO NOT EDIT\n"
// 			    "#\n"
// 			    "depend() { \n"
// 			    "\tuse net \n"
// 			    "}\n"
// 			    "start() {\n"
// 			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh start\n"
// 			    "\teend $? \n"
// 			    "}\n\n"
// 			    "stop () {\n"
// 			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh stop\n"
// 			    "\teend $? \n"
// 			    "}\n\n";
// 			ts << s << endl;
// 		} else {
// 			kdDebug() << "Writing normal init script." << endl;
// 			s = "#!/bin/sh\n"
// 			    "#\n"
// 			    "# " + copyright_string + "\n"
// 			    "# 	mail to: " + maintainer + "\n"
// 			    "#\n"
// 			    "# Start/Stop script for KMyFirewall " + version + "\n"
// 			    "# This is an automatic generated file DO NOT EDIT\n"
// 			    "#\n"
// 			    "status=\"0\"\n"
// 			    "case $1 in\n"
// 			    "	start)\n"
// 			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh start || status=\"1\"\n"
// 			    "	;;\n\n"
// 			    "	stop)\n"
// 			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh stop || status=\"1\"\n"
// 			    "	;;\n\n"
// 			    "	reload)\n"
// 			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh stop || status=\"1\"\n"
// 			    "	/bin/sh /etc/kmyfirewall/kmyfirewall.sh start || status=\"1\"\n"
// 			    "	;;\n\n"
// 			    "esac\n"
// 			    "if [ \"$status\" = \"0\" ]; then\n"
// 			    "	exit 0\n"
// 			    "else\n"
// 			    "	exit 1\n"
// 			    "fi\n";
// 			ts << s << endl;
// 		}
// 		f.flush();
// 		f.close();
// 	} else {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "<p>Opening file for writing <b>failed</b>."
// 		                           "Please make sure that you are logged in as <b>root</b>." );
// 		m_err->setErrMsg( msg );
// 		return m_err;
// 	}
// 	m_err->setErrType( KMFError::OK );
// 	const TQString& msg = "";
// 	m_err->setErrMsg( msg );
// 	return m_err;
// }


// void KMFPFInstaller::writeBase64DataField( const TQString& source_file_path, const TQString& target_file_path, const TQString& data ) {
// TQStringList lines;
// 	TQFile source_file( source_file_path );
// 	if ( source_file.open( IO_ReadOnly ) ) {
// 		TQTextStream stream( &source_file );
// 		TQString line;
// 		int i = 1;
// 		while ( !stream.atEnd() ) {
// 			line = stream.readLine(); // line of text excluding '\n'
// 			i++;
// 			kdDebug() << "line.latin1(): " << line.latin1() << endl;
// 			lines += line;
// 		}
// 		source_file.close();
// 	} else {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "<p>Opening file for %1 reading <b>failed</b>." ).arg( source_file_path );
// 		m_err->setErrMsg( msg );		
// 	}
// 	
// 	TQString corrData = data;
// 	for ( TQStringList::Iterator it = lines.begin(); it != lines.end(); ++it ) {
// 		(*it).replace( "%data%", corrData );
// 	}
// 	
// 	TQFile target_file( target_file_path );
// 	if ( target_file.open( IO_WriteOnly ) ) {
// 		TQTextStream stream( &target_file );
// 		int i = 1;
// 		
// 		for ( TQStringList::Iterator it2 = lines.begin(); it2 != lines.end(); ++it2 ) {
// 			stream << *it2 << "\n";
// 			i++;
// 			kdDebug() << "(*it2).latin1():  " << (*it2).latin1() << endl;
// 		}
// 		target_file.close();
// 	} else {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "<p>Opening file for %1 writing <b>failed</b>." ).arg( target_file_path );
// 		m_err->setErrMsg( msg );		
// 	}
// }

// void KMFPFInstaller::parseFileHeaders( const TQString& source_file_path, const TQString& target_file_path ) {
// 	kdDebug() << "KMFPFInstaller::parseFileHeaders( const TQString& " << source_file_path << ", const TQString& " << target_file_path << " )" << endl;
// 	
// 	TQString version = KMYFIREWALL_VERSION;
// 	TQString copyright_string = COPYRIGHT_STRING;
// 	TQString maintainer = MAINTAINER;
// 	TQString license = LICENSE;
// 
// 	
// 	TQStringList lines;
// 	TQFile source_file( source_file_path );
// 	if ( source_file.open( IO_ReadOnly ) ) {
// 		TQTextStream stream( &source_file );
// 		TQString line;
// 		int i = 1;
// 		while ( !stream.atEnd() ) {
// 			line = stream.readLine(); // line of text excluding '\n'
// 			i++;
// 			kdDebug() << "line.latin1(): " << line.latin1() << endl;
// 			lines += line;
// 		}
// 		source_file.close();
// 	} else {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "<p>Opening file for %1 reading <b>failed</b>." ).arg( source_file_path );
// 		m_err->setErrMsg( msg );		
// 	}	
// 	
// 	for ( TQStringList::Iterator it = lines.begin(); it != lines.end(); ++it ) {
// 		(*it).replace( "%coypright%", copyright_string );
// 		(*it).replace( "%version%", version );
// 		(*it).replace( "%maintainer%", maintainer );
// 		(*it).replace( "%license%", license );
// 	}
// 	
// 	TQFile target_file( target_file_path );
// 	if ( target_file.open( IO_WriteOnly ) ) {
// 		TQTextStream stream( &target_file );
// 		int i = 1;
// 		
// 		for ( TQStringList::Iterator it2 = lines.begin(); it2 != lines.end(); ++it2 ) {
// 			stream << *it2 << "\n";
// 			i++;
// 			kdDebug() << "(*it2).latin1():  " << (*it2).latin1() << endl;
// 		}
// 		target_file.close();
// 	} else {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "<p>Opening file for %1 writing <b>failed</b>." ).arg( target_file_path );
// 		m_err->setErrMsg( msg );		
// 	}
// }

// void KMFPFInstaller::generateInstallerPackage( KMFTarget* tg ) {
// 	if ( rulesetDoc() ) {
// 		KMFTargetConfig *conf = tg->config();
// 	
// 		KMFPFInstallerInterface *inst2 = KMFPluginFactory::KMFPFInstaller(
// 				conf->oS(), conf->backend(), parent() ); 
// 		if ( ! inst2 )
// 			return;
// 		inst2->loadScript( rulesetDoc()->compile() );
// 		
// 		TQString remDir = rulesetDoc()->target()->getFishUrl();
// 		remDir.append( "/tmp/" );
// 		
// 		TQString path = remDir;
// 		path.append( "kmfpackage.kmfpkg" );
// 		KURL url( path );
// 		KURL remDirUrl( remDir );
// 		
// 		if ( url.fileName().isEmpty() )
// 			return;
// 		
// 		if ( TDEIO::NetAccess::exists( url, false, tdeApp->mainWidget() ) ) {
// 			TQDateTime now = TQDateTime::currentDateTime();
// 			
// 			TQString backUp;
// 			backUp.append( url.url() );
// 			backUp.append( "_backup_" );
// 			backUp.append( now.toString( "dd.MM.yyyy.hh:mm:ss" ) );
// 			KURL newUrl( backUp );
// 			
// 			
// 			TQString backFileName = "kmfpackage.kmfpkg";
// 			backUp.append( "_backup_" );
// 			backUp.append( now.toString( "dd.MM.yyyy.hh:mm:ss" ) );
// 			
// 			
// 			TDEIO::NetAccess::file_move( url, newUrl, 700, true, true, tdeApp->mainWidget() );
// 			TDEIO::NetAccess::fish_execute( remDir, "chmod 400 /tmp/" + backFileName, tdeApp->mainWidget() );
// 		}
// 		
// 		inst2->generateInstallerPackage( tg, url );
// 		TDEIO::NetAccess::fish_execute( remDir, "chmod 700 /tmp/kmfpackage.kmfpkg", tdeApp->mainWidget() );
// 	}
// }

void KMFPFInstaller::generateInstallerPackage( KMFTarget* target, const KURL& packageURL ) {
	kdDebug() << "generateInstallerPackage( const KURL& )" << endl;
// 	
// 	KMFTargetConfig *conf = target->config();	
// 	
// 	KTempFile *startup_script = new KTempFile();
// 	KTempFile *packageArch = new KTempFile();
// 	KTempFile *fw_script = new KTempFile();
// 	KTempFile *init_script_sysv = new KTempFile();	
// 	KTempFile *init_script_gentoo = new KTempFile();
// 	KTempFile *kmf_intsall = new KTempFile();
// 	KTempFile *kmf_pkg_intsall = new KTempFile();	
// 	KTempFile *kmf_install_package = new KTempFile();
// 	
// 	KURL readme_url ( TDEGlobal::dirs() ->findResource( "appdata", "README.InstallerPackage.txt" ));
// // 	TQString readme_txt = readme_url.path();
// 	if ( readme_url.path().isEmpty() ) {
// 		TQString msg = i18n( "<p>Unable to find the package README script <b>README.InstallerPackage.txt</b>"
// 				"<p>Please check your installation. Usually this file is installed in "
// 				"$TDEDIR/share/apps/kmyfirewall/"
// 				"<p>The package will be built without the README file." );
// 		TQString cap = "KMFPFInstaller";
// 		KMessageBox::error( 0, msg, cap );
// 		// return;
// 	}
// 	kdDebug() << "found readme script: " << readme_url.path() << endl;	
// 	
// 	
// 	KURL kmfinstall_url ( TDEGlobal::dirs() ->findResource( "appdata", "scripts/installer/" + target->config()->oS() + "/kmfinstall.sh" ));
// 	if ( kmfinstall_url.path().isEmpty() ) {
// 		TQString msg = i18n( "<p>Unable to find install script <b>kmfinstall.sh</b>"
// 				"<p>Please check your installation. Usually this script is installed in "
// 				"$TDEDIR/share/apps/kmyfirewall/scripts/installer/" + target->config()->oS() + ""
// 				"<p>Unable to install the firewall without this script." );
// 		TQString cap = "KMFPFInstaller";
// 		KMessageBox::error( 0, msg, cap );
// 		return;
// 	}
// 	kdDebug() << "found Install script: " << kmfinstall_url.path() << endl;	
// 	
// 	parseFileHeaders( kmfinstall_url.path(), kmf_intsall->name() );
// 
// 	
// 	
// 	KURL kmfpgkinstall_url ( TDEGlobal::dirs() ->findResource( "appdata", "scripts/installer/" + target->config()->oS() + "/kmfpkginstall.sh" ));
// 	if ( kmfpgkinstall_url.path().isEmpty() ) {
// 		TQString msg = i18n( "<p>Unable to find install script <b>kmfinstall.sh</b>"
// 				"<p>Please check your installation. Usually this script is installed in "
// 				"$TDEDIR/share/apps/kmyfirewall/scripts/installer/" + target->config()->oS() + ""
// 				"<p>Unable to install the firewall without this script." );
// 		TQString cap = "KMFPFInstaller";
// 		KMessageBox::error( 0, msg, cap );
// 		return;
// 	}
// 	kdDebug() << "found PKG Install script: " << kmfpgkinstall_url.path() << endl;
// 	
// 	parseFileHeaders( kmfpgkinstall_url.path(), kmf_pkg_intsall->name() );
// 	
// 	
// 	KURL kmf_install_package_url ( TDEGlobal::dirs() ->findResource( "appdata", "scripts/installer/" + target->config()->oS() + "/installpackage.sh" ));
// 	if ( kmf_install_package_url.path().isEmpty() ) {
// 		TQString msg = i18n( "<p>Unable to find install package script <b>installpackage.sh</b>"
// 				"<p>Please check your installation. Usually this script is installed in "
// 				"$TDEDIR/share/apps/kmyfirewall/scripts/installer/" + target->config()->oS() + ""
// 				"<p>Unable to install the firewall without this script." );
// 		TQString cap = "KMFPFInstaller";
// 		KMessageBox::error( 0, msg, cap );
// 		return;
// 	}
// 	kdDebug() << "found PKG Install script: " << kmf_install_package_url.path() << endl;
// 	
// 	parseFileHeaders( kmf_install_package_url.path(), kmf_install_package->name() );
// 	
// 	TQString systemtype;
// 	if ( conf->distribution() == "gentoo" ) {
// 		systemtype = "gentoo";
// 	} else if( conf->distribution() == "slackware" ) {
// 		systemtype = "slackware";
// 	} else {
// 		systemtype = "sysv";
// 	}
// 	
// // 	const TQString initscript_sysv = init_script_sysv->name();
// // 	const TQString initscript_gentoo = init_script_gentoo->name();
// // 	const TQString fwscript = fw_script->name();
// 	m_err = createFirewallScript( fw_script->name() );
// 	if ( ! m_err_handler->showError( m_err ) ) {
// 		return;
// 	}
// 	
// 	m_err = createInitScript( init_script_sysv->name(), "sysv" );
// 	if ( ! m_err_handler->showError( m_err ) ) {
// 		return;
// 	}
// 	
// 	m_err = createInitScript( init_script_gentoo->name(), "gentoo" );
// 	if ( ! m_err_handler->showError( m_err ) ) {
// 		return;
// 	}
// 	
// 	TQString version = KMYFIREWALL_VERSION;
// 	TQString copyright_string = COPYRIGHT_STRING;
// 	TQString maintainer = MAINTAINER;
// 
// 	
// 	TQFile f( startup_script->name() );
// 	bool gotit = f.open( IO_ReadWrite );
// 	if ( gotit ) {
// 		TQTextStream ts( &f );
// 		//Header
// 		TQString s;
// 		
// 		kdDebug() << 	"Package install script." << endl;
// 		s = 		"#!/bin/sh\n"
// 				"#\n"
// 				"# " + copyright_string + "\n"
// 				"# 	Please report bugs to: " + maintainer + "\n"
// 				"#\n"
// 				"# config script for KMyFirewall " + version + " package instsll script\n"
// 				"# This is an automatic generated file DO NOT EDIT\n"
// 				"#\n" +
// 				"# Configuration created for " + target->toFriendlyString() + "\n" +
// 				"#\n"
// 				"#\n\n";
// 		s += 		"SYSTEMTYPE=" + systemtype + "\n";
// 		s += 		"INITPATH=" + conf->initPath() + "\n";
// 		s += 		"RCDEFAULTPATH=" + conf->rcDefaultPath() + "\n"
// 				"INITSCRIPT=data/init_sysv.sh\n"
// 				"if [ \"$SYSTEMTYPE\" == \"gentoo\" ]; then\n"
// 				"	INITSCRIPT=data/init_gentoo.sh\n"
// 				"fi\n";
// 		ts << s << endl;
// 		
// 		f.flush();
// 		f.close();	
// 	} else {
// 		m_err->setErrType( KMFError::NORMAL );
// 		const TQString& msg = i18n( "<p>Opening file for writing <b>failed</b>."
// 				"Please make sure that you are logged in as <b>root</b>." );
// 		m_err->setErrMsg( msg );
// 		m_err_handler->showError( m_err );
// 		kdWarning() << "!!! Opening file for writing failed !!!" << endl;
// 		return;
// 	}
// 	
// 	KTar *package = new  KTar( packageArch->name(), "application/x-gzip" );
// 	package->open( IO_WriteOnly );
// 	
// 	package->addLocalFile( readme_url.path(), "README.txt" );
// 	kdDebug() << "Wrote  tar file: README.txt" << endl; 
// 	
// 	package->addLocalFile( startup_script->name(), "install.config" );
// 	kdDebug() << "Wrote  tar file: install.config" << endl; 
// 	
// 	package->addLocalFile( kmf_pkg_intsall->name(), "install.sh" );
// 	kdDebug() << "Wrote  tar file: install.sh" << endl; 
// 	
// 	package->addLocalFile( kmf_intsall->name(), "data/kmfinstall.sh" );
// 	kdDebug() << "Wrote  tar file: kmfinstall.sh" << endl; 
// 	
// 	package->addLocalFile( init_script_sysv->name(), "data/init_sysv.sh" );
// 	kdDebug() << "Wrote  tar file: data/init_sysv.sh" << endl; 
// 	
// 	package->addLocalFile( init_script_gentoo->name(), "data/init_gentoo.sh" );
// 	kdDebug() << "Wrote  tar file: data/init_gentoo.sh" << endl; 
// 	
// 	package->addLocalFile( fw_script->name(), "data/kmyfirewall.sh" );
// 	kdDebug() << "Wrote  tar file: data/kmyfirewal.sh" << endl; 
// 	package->close();
// 	
// 	TQFile fPackage( packageArch->name() );
// 	if ( fPackage.open( IO_ReadOnly ) ) {
// 		TQByteArray b = fPackage.readAll();
// 		TQString rawData = KCodecs::base64Encode( b, false );
// 		rawData = rawData.replace( '\n', ' ' );
// 		TQString data;
// 		int len = rawData.length();
// 		int currPos = 0;
//  		bool doit = true;
//  		
//  		while( doit ) {
// 			int lineLen = 76;
// 			if ( ( len - currPos ) < lineLen ) {
// 				lineLen = len - currPos;
// 				doit = false;
// 			}
// 			kdDebug() << "Appending : " <<  rawData.mid( currPos, lineLen ) << endl;
// 			data.append( rawData.mid( currPos, lineLen ) );
// 			data.append( " " );
// 			currPos +=  lineLen;
// 		}
// 		
// 		
// 		kdDebug() << "Encoded package: " << data << endl;
// 		writeBase64DataField( kmf_install_package->name(), kmf_install_package->name(), data );
// 	}
// 	
// 	
// 	
// 	
// 	
// 	// TDEIO::NetAccess::upload( packageArch->name(), packageURL, tdeApp->mainWidget() );
// 	TDEIO::NetAccess::upload( kmf_install_package->name(), packageURL, tdeApp->mainWidget() );
// 	
// 	kdDebug() << "Wrote  package: " <<  packageURL.prettyURL()  << endl; 
// 
// 	startup_script->close();
// 	packageArch->close();
// 	fw_script->close();
// 	init_script_sysv->close();
// 	init_script_gentoo->close();
// 	kmf_intsall->close();
// 	kmf_pkg_intsall->close();
// 	kmf_install_package->close();
// 	
// 	startup_script->unlink();
// 	packageArch->unlink();
// 	fw_script->unlink();
// 	init_script_sysv->unlink();
// 	init_script_gentoo->unlink();
// 	kmf_intsall->unlink();
// 	kmf_pkg_intsall->unlink();
// 	kmf_install_package->unlink();
}

// 
// void KMFPFInstaller::loadIcons() {
// 	kdDebug() << "void KMFPFInstaller::loadIcons()" << endl;
// 	TDEIconLoader *loader = TDEGlobal:: iconLoader();
// 	TQString icon_name;
// 	icon_name = "encrypted";
// 	icon_run = loader->loadIcon( icon_name, TDEIcon::Toolbar );
// 
// 	icon_name = "decrypted";
// 	icon_stop = loader->loadIcon( icon_name, TDEIcon::Toolbar );
// 
// 	icon_name = "openterm";
// 	icon_show = loader->loadIcon( icon_name, TDEIcon::Toolbar );
// }

// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// TDEInstance* KMFIPTablesCompilerFactory::s_instance = 0L;
// TDEAboutData* KMFIPTablesCompilerFactory::s_about = 0L;

KMFPFInstallerFactory::KMFPFInstallerFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new TDEInstance( "KMFIPTablesCompilerFactory" );
}

TQObject* KMFPFInstallerFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFPFInstaller( parent, name );
	emit objectCreated( obj );
	return obj;
}


// TDEInstance* KMFIPTablesCompilerFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new TDEInstance( "KMFIPTablesCompilerFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	TDE_EXPORT void* init_libkmfinstaller_openbsd() {
		return new KMFPFInstallerFactory;
	}
}

}

