//
// C++ Interface: kmfnethost
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFNETHOST_H
#define KMFNETHOST_H

#include "kmftarget.h"
#include "netfilterobject.h"


// TQt includes
#include <tqptrlist.h>
#include <tqguardedptr.h>
#include <tqstring.h>
#include <tqdom.h>
#include <tquuid.h>

// KDE includes
#include <tdemacros.h>


// Project includes

namespace KMF {
class KMFGenericDoc;
class KMFProtocol;
class KMFProtocolUsage;
class KMFError;
class KMFCheckInput;
class KMFNetZone;
class IPAddress;
class KMFNetwork;

/**
@author Christian Hubinger
*/

class TDE_EXPORT KMFNetHost : public KMFTarget {
	TQ_OBJECT
  
public:
	KMFNetHost( NetfilterObject *parent, const char* name, const TQString& Hostname, KMFNetwork* net );
	virtual ~KMFNetHost();

	virtual int type();
	virtual void clear();
	
	bool logIncoming() {
		return m_logIncoming;
	}
	void setLogIncoming( bool );

	bool logOutgoing() {
		return m_logOutgoing;
	}
	void setLogOutgoing( bool );

	void setLimit( int num, const TQString& scale );
	
	bool limit() const;
	int limitRate() const;
	const TQString& limitScale() const;
	
	virtual const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	KMFProtocolUsage* addProtocolUsage( const TQUuid& protocolUuid, const TQDomDocument& xml );
	
	void delProtocolUsage( KMFProtocolUsage*, bool destructive = true );
	bool protocolInherited( const TQUuid& uuid ) const;
	KMFProtocolUsage* findProtocolUsageByProtocolUuid( const TQUuid& uuid ) const;
	
	TQPtrList<KMFProtocolUsage>& protocols() const;

protected slots:
	void slotOnProtocolUsageDeleted( TQObject* protocol );
	
private: // Data
// 	int m_maskLen;
	TQPtrList<KMFProtocolUsage> m_protocols;
	bool m_logIncoming, m_logOutgoing;
	TQString m_limitScale;
	int m_limitNum;
};
}
#endif
