/***************************************************************************
 *     Copyright (C) 2004 by Sashmit Bhaduri                               *
 *     smt@vfemail.net                                                     *
 *                                                                         *
 *     Licensed under GPL.                                                 *
 ***************************************************************************/

#ifndef TABWIDGET_H
#define TABWIDGET_H

#include "frame.h"

#include <ktabwidget.h>

#include <tqptrdict.h>
#include <tqstringlist.h>

namespace KlamAV
{

class TabWidget:public KTabWidget
{
    TQ_OBJECT

    public:
        TabWidget(TQWidget * parent = 0, const char *name = 0, TQStringList fixedTabs = 0);
        ~TabWidget();
        void addFrame(Frame *f);
        Frame *currentFrame();
        void removeFrame(Frame *f);

        unsigned int tabBarWidthForMaxChars( uint maxLength );
        void setTitle( const TQString &title , TQWidget* sender);

    public slots:

        void slotSettingsChanged();
    signals:
        
        void currentFrameChanged(Frame *);
	void tabClosed(TQString);
        
    private: // methods
        
    private slots:
        
	void slotMoveTabLeft();
	void slotMoveTabRight();
        void slotCloseTab();
        void slotCloseRequest(TQWidget* widget);
        void contextMenu (int item, const TQPoint &p);
        void slotTabChanged(TQWidget *w);
        
   private: // attributes

       TQPtrDict<Frame> m_frames;
       unsigned int m_CurrentMaxLength;
       int currentItemId;
       TQWidget* currentItem;
       TQStringList fixedTabs;
};

}

#endif
