#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )
check_function_exists( getpeereid HAVE_GETPEEREID )


##### check for gtk+ 2.x

if( BUILD_KGTK_GTK2 )

  pkg_check_modules( GTK gtk+-2.0>=2.6 )
  pkg_check_modules( GTHREAD gthread-2.0 )

  if( NOT GTK_FOUND OR NOT GTHREAD_FOUND )
    tde_message_fatal( "GTK2 support is requested but not found on your system" )
  endif()

  check_library_exists( "${CMAKE_DL_LIBS}" _dl_sym "" HAVE_DL_SYM )
  if( NOT HAVE_DL_SYM )
    message( WARNING, "_dl_sym is requested but not found on your system.\n"
                      "Some functionality may not be available unless your\n"
                      "system has glibc 2.34 or greater." )
  endif()

endif()
