
/***************************************************************************
 *                                                                         *
 *   KCPULoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KCPUDOCK_H
#define __KCPUDOCK_H

#include "statdock.h"

/**
 * A KCPULoad system tray window for a specific CPU.
 */
class KCPUDock : public StatDock {

public:
    /**
     * Constructor.
     */
    KCPUDock(int whichDock, StatPopup *parent = 0, const char *name = 0);

    /**
     * Sets the label for this diagram.  The label will reflect which
     * CPU the diagram represents.
     *
     * If multiple CPUs are not used, argument cpu should be 0.
     * Otherwise argument cpu should be 1 or 2 for the first or second
     * CPU respectively.
     */
    void setCPULabel(int cpu);
};

#endif
