/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tqstringlist.h>
#include <tqlabel.h>
#include <tqmap.h>

#include <tdeapplication.h>
#include <tdesimpleconfig.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdestandarddirs.h>
#include <kiconloader.h>
#include <dcopclient.h>
#include <tdeprocess.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kwizard.h>
#include <kdialogbase.h>
#include <tqpushbutton.h>

#include "realmfinishpage.h"

PrimaryRealmFinishPage::PrimaryRealmFinishPage(TQWidget *parent, const char *name ) : PrimaryRealmFinishPageDlg(parent,name) {

	px_introSidebar->setPixmap(UserIcon("kcmldapcontroller_step4.png"));

	connect(ldapAdminUsername, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(ldapAdminGroupname, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(ldapMachineAdminGroupname, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));
	connect(ldapStandardUserGroupname, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(validateEntries()));

	m_parentWizard = dynamic_cast<KWizard*>(parent);
	m_parentDialog = dynamic_cast<KDialogBase*>(parent);
}

PrimaryRealmFinishPage::~PrimaryRealmFinishPage(){
	// 
}

void PrimaryRealmFinishPage::validateEntries() {
	if (m_parentWizard) {
		if ((ldapAdminUsername->text() != "") && (ldapAdminGroupname->text() != "") && (ldapMachineAdminGroupname->text() != "") && (ldapStandardUserGroupname->text() != "")) {
			m_parentWizard->finishButton()->setEnabled(true);
		}
		else {
			m_parentWizard->finishButton()->setEnabled(false);
		}
	}
	if (m_parentDialog) {
		if ((ldapAdminUsername->text() != "") && (ldapAdminGroupname->text() != "") && (ldapMachineAdminGroupname->text() != "") && (ldapStandardUserGroupname->text() != "")) {
			m_parentDialog->enableButton(KDialogBase::Ok, true);
		}
		else {
			m_parentDialog->enableButton(KDialogBase::Ok, false);
		}
	}
}

#include "realmfinishpage.moc"
