/*
 * notify.cpp
 * Copyright (C) 1999-2008 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the implementation of the KBiffNotify
 * widget
 */
#include "notify.h"
#include "notify.moc"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqpushbutton.h>

#include <tdeapplication.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdeprocess.h>
#include <twin.h>

KBiffNotify::KBiffNotify(TQWidget *parent_, const int num_new,
			 const TQString& mailbx)
    : TQDialog(parent_, 0, false, 0)
{
    KWin::setIcons(winId(), tdeApp->icon(), tdeApp->miniIcon());
    setCaption(i18n("You have new mail!"));

    TQLabel *pixmap = new TQLabel(this);
    pixmap->setPixmap(tdeApp->icon());
    pixmap->setFixedSize(pixmap->sizeHint());

    TQLabel *congrats = new TQLabel(i18n("You have new mail!"), this);
    TQFont the_font(congrats->font());
    the_font.setBold(true);
    congrats->setFont(the_font);

    TQString msg;
    msg = i18n("New Messages: %1").arg(num_new);
    msgLabel = new TQLabel(msg, this);

    msg = i18n("Mailbox: %1").arg(mailbx);
    TQLabel *which_one = new TQLabel(msg, this);

    TQPushButton *ok = new TQPushButton(i18n("OK"), this);
    ok->setDefault(true);

    TQPushButton *launch = new TQPushButton(i18n("Mailer"), this);

    // connect the signals to slots
    connect(ok, TQ_SIGNAL(clicked()), TQ_SLOT(accept()));
    connect(launch, TQ_SIGNAL(clicked()), TQ_SLOT(slotLaunchMailClient()));
    connect(launch, TQ_SIGNAL(clicked()), this, TQ_SLOT(accept()));

    // Now do the layout
    TQVBoxLayout *info_layout = new TQVBoxLayout(12);
    info_layout->addWidget(congrats);
    info_layout->addWidget(msgLabel);
    info_layout->addWidget(which_one);

    TQHBoxLayout *upper_layout = new TQHBoxLayout;
    upper_layout->addWidget(pixmap);
    upper_layout->addLayout(info_layout, 1);

    TQHBoxLayout *button_layout = new TQHBoxLayout;
    button_layout->addStretch(1);
    button_layout->addWidget(launch);
    button_layout->addWidget(ok);
    button_layout->addStretch(1);

    TQVBoxLayout *top_layout = new TQVBoxLayout(this, 12);
    top_layout->addLayout(upper_layout);
    top_layout->addLayout(button_layout);

    mailbox = mailbx;
    messages = num_new;
}

KBiffNotify::~KBiffNotify()
{
}

void KBiffNotify::setNew(const int num_new)
{
    TQString msg;
    msg = i18n("New Messages: %1").arg(num_new);
    msgLabel->setText(msg);
    messages = num_new;
}

void KBiffNotify::slotLaunchMailClient()
{
    emit(signalLaunchMailClient());
}
