/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



//Own includes
#include "kstartuplogo.h"

//TQt includes
#include <tqapplication.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpixmap.h>

//TDE includes
#include <tdeapplication.h>
#include <tdestandarddirs.h>
//#include <kimageio.h>

//static objects
TDEStartupLogo* TDEStartupLogo::startupLogo = 0;

void TDEStartupLogo::createSplash() {
	deleteSplash();
	startupLogo = new TDEStartupLogo();
}

void TDEStartupLogo::showSplash() {
	if (TDEStartupLogo::startupLogo) {
		TDEStartupLogo::startupLogo->show();
	}
}

void TDEStartupLogo::hideSplash() {
	if (startupLogo) {
		startupLogo->hide();
	}
}

void TDEStartupLogo::deleteSplash() {
	delete startupLogo;
	startupLogo = 0;
}


void TDEStartupLogo::setStatusMessage(const TQString& message) {
	if (startupLogo) {
		startupLogo->setText(message);
	}
}

TDEStartupLogo::TDEStartupLogo()
: TQWidget(0, "startuplogo", /*WStyle_Customize | WStyle_NoBorder*/ WStyle_NoBorder|WStyle_StaysOnTop|WX11BypassWM ) {

	TQPixmap pm;
	if ( !pm.load(locate("BT_pic","startuplogo.png")) ) {
		tqWarning("Can't load startuplogo! Check your installation.");
	}

	setBackgroundPixmap(pm);

	//Please not change the margin
	textLabel = new TQLabel(this);
	textLabel->setGeometry(0,pm.height(),pm.width(),textLabel->sizeHint().height()+10);
	textLabel->setBackgroundColor( TQColor("#0d6de9") );
	textLabel->setFrameStyle(TQFrame::Panel | TQFrame::Plain);
	textLabel->setLineWidth(1);
	textLabel->setScaledContents( true );

	TQFont f;
	f.setBold( true );
	textLabel->setFont( f );

	TQPalette p = palette();
	p.setColor( TQPalette::Inactive, TQColorGroup::Text, TQt::white );
	p.setColor( TQPalette::Inactive, TQColorGroup::Foreground, TQt::white );
	p.setColor( TQPalette::Active, TQColorGroup::Text, TQt::white );
	p.setColor( TQPalette::Active, TQColorGroup::Foreground, TQt::white );
	setPalette( p );

	setGeometry (
		(TDEApplication::desktop()->width()-pm.width())/2,
		(TDEApplication::desktop()->height()-pm.height()-textLabel->height())/2,
		pm.width(),
		pm.height()+textLabel->height()
	);
}

void TDEStartupLogo::setText(const TQString text) {
	//Please not make the text bold & let the first character be blank
	textLabel->setText( TQString::fromLatin1(" %1").arg(text) );
	tdeApp->processEvents();
}

/** Makes the splashscreen the toplevel window. */
void TDEStartupLogo::raiseSplash() {
	if (startupLogo) {
		startupLogo->raise();
		startupLogo->setActiveWindow();
		startupLogo->textLabel->show();
	}
}

/** Lowers the splash screen one window down, so it's possible to make it not to hide tip windows or other startup stuff. */
void TDEStartupLogo::lowerSplash() {
	if (startupLogo) {
		startupLogo->lower();
	}
}
