/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CMODULERESULTSVIEW_H
#define CMODULERESULTSVIEW_H

//BibleTime includes
#include "backend/cswordmoduleinfo.h"
#include "csearchdialogpages.h"

//TQt includes

//TDE includes
#include <tdelistview.h>

//forward declarations
class TQLabel;
class TQCheckBox;
class TQPushButton;
class TQRadioButton;

class KComboBox;
class TDEActionMenu;
class TDEAction;
class KHistoryCombo;
class KProgress;
class TDEPopupMenu;

class CReadDisplay;

namespace Search {
	namespace Result {
		
class CModuleResultView : public TDEListView {
	TQ_OBJECT
  
public:
	CModuleResultView(TQWidget* parent, const char* name = 0);
	~CModuleResultView();
	
	/**
	* Setups the tree using the given list of modules.
	*/
	void setupTree( ListCSwordModuleInfo modules, const TQString& searchedText );
	/**
	* Returns the currently active module.
	*/
	CSwordModuleInfo* const activeModule();

protected: // Protected methods
	/**
	* Initializes this widget.
	*/
	void initView();
	/**
	* Initializes the connections of this widget
	*/
	void initConnections();

   void setupStrongsResults(CSwordModuleInfo* module, TQListViewItem* parent, const TQString& searchedText);

protected slots: // Protected slots
	/**
	* Is executed when an item was selected in the list.
	*/
	void executed( TQListViewItem* );
	/**
	* Copies the whole search result with the text into the clipboard.
	*/
	void copyResultWithText();
	/**
	* Copies the whole search result into the clipboard.
	*/
	void copyResult();
	/**
	* This slot opens the popup menu at the given position
	*/
	void showPopup(TDEListView*, TQListViewItem*, const TQPoint&);
	/**
	* Appends the whole search result to the printer queue.
	*/
	void printResult();
	/**
	* Saves the search result with it's text.
	*/
	void saveResultWithText();
	/**
	* Saves the search result keys.
	*/
	void saveResult();

signals:
	void moduleSelected(CSwordModuleInfo*);
	void moduleChanged();
   void strongsSelected(CSwordModuleInfo*, TQStringList*);

private:
	struct {
		TDEActionMenu* saveMenu;
		struct {
			TDEAction* result;
			TDEAction* resultWithText;
		}
		save;

		TDEActionMenu* printMenu;
		struct {
			TDEAction* result;
		}
		print;

		TDEActionMenu* copyMenu;
		struct {
			TDEAction* result;
			TDEAction* resultWithText;
		}
		copy;

	} m_actions;
	
	TDEPopupMenu* m_popup;
	StrongsResultClass* strongsResults;
};

	} //end of namespace Search::Result
} //end of namespace Search

#endif
