/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@mksat.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef NAVIGATOR_H
#define NAVIGATOR_H

#include <tqobject.h>
#include <codemodel.h>
#include <tqfont.h>
#include <fancylistviewitem.h>

class TextPaintStyleStore;
class TQTimer;
class ClassViewPart;
class TQListViewItem;
class TDEAction;

#define NAV_NODEFINITION "(no function)"

class TextPaintItem;
TextPaintItem highlightFunctionName( TQString function, int type, TextPaintStyleStore& styles );

class Navigator : public TQObject
{
TQ_OBJECT
  
public:
    enum NavigationState { GoToDefinitions, GoToDeclarations };

    Navigator(ClassViewPart *parent, const char *name = 0);
    ~Navigator();

    void stopTimer();
    void refreshNavBars(const TQString &activeFileName, bool clear = true);

    TQString fullFunctionDefinitionName(FunctionDefinitionDom fun);
    TQString fullFunctionDeclarationName(FunctionDom fun);

    template <class DomType>
    TextPaintItem fullFunctionItem(DomType fun);
    
public slots:
    void selectFunctionNav(TQListViewItem *item);
    void syncFunctionNav();
    void syncFunctionNavDelayed(int delay);
    void functionNavFocused();
    void functionNavUnFocused();
    void slotCursorPositionChanged();
    void refresh();
    void addFile(const TQString &file);
    void slotSyncWithEditor();
    void slotJumpToNextFunction();
    void slotJumpToPreviousFunction();

protected:

    FunctionDom currentFunction();
    TQValueList<int> functionStartLines();

private:
    ClassViewPart *m_part;
    TQTimer *m_syncTimer;
    NavigationState m_state;

    TQWidget m_dummyActionWidget;
    TDEAction* m_actionSyncWithEditor;

    bool m_navNoDefinition;

    TQMap<TQString, TQListViewItem*> m_functionNavDefs;
    TQMap<TQString, TQListViewItem*> m_functionNavDecls;
    
    TextPaintStyleStore m_styles;
};

#endif
