/***************************************************************************
                          knutnewupsdlg.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel@prynych.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTNEWUPSDLG_H
#define KNUTNEWUPSDLG_H

#include "knutupsdata.h"
#include "knutvardata.h"

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <tdeactionselector.h>

#include <tqlistbox.h>


class TQLabel;
class TQGroupBox;
class TQButtonGroup;
class TQCheckBox;

/**
 * This class is dialog for makeing or correting informations about UPS.
 * It can set address, port and seletcts values its values will be found,
 * Tato trida je dialog pro vytvoreni nebo opravu informaci a UPS.
 * Umoznuje nastavit adresu, port, a vybrat promennou jejiz hodnota se bude zjistovat.
 * @author Daniel Prynych
 * @short Panel for setting parameters of UPS 
 *
 * @version 0.4
 */
class KNutNewUpsDlg : public KDialogBase
{
    TQ_OBJECT
  

public:

/**
 * Constructor - makes configure dialog.
 * Konstruktor - vytvori konfiguracni dialog.
 *
 * @param add Urcuje zda budeme data opravovat nebo pridavat.
 * @param settingData pointer on structure, which includes values which is setted in dialog.
 * @param upsdata is pointer on instance of class KNutUpsData.
 * @param analogData is pointer on instance of class KNutVardata
 * @param add Urcuje zda budeme data opravovat nebo pridavat.
 * @param settingData Je odkaz na strukturu ktera obsahuje hodnoty nastavovane v dialogu.
 * @param upsData Je odkaz na na instanci tridy KNutUpsData.
 * @param analogData Je odkaz na na instanci tridy KNutVarData.
 *
 * @since  0.7
 **/
  KNutNewUpsDlg (KNutUpsData* const upsData, KNutVarData* const analogData, const bool add = true, TQWidget* parent = 0, const char* name = 0, const bool modal = true);

/**
 * @since  0.3
 **/
 ~KNutNewUpsDlg();

/**
 * Reads data from items of form.
 * Precte data z polozek formulare.
 *
 * @param upRecordDef Struktura of UpsInfo - contains all items which is included in form.
 * @param upsRecordDef Struktura UpsInfo - obsahuje vsechny polozky ktere jsou ve formulari.
 *
 * @since  0.4
 **/
 KNutUpsData::upsRecordDef getData (void ) const;

/**
 * Puts date into intems of form
 * Vlozi data do polozek formulare.
 *
 * @param upsRecord Struktura of upsRecordDef - contains all items which is included in form.
 * @param upsRecord Struktura psRecordDef - obsahuje vsechny polozky ktere jsou ve formulari.
 *
 * @since  0.4
 **/
  void putData (const KNutUpsData::upsRecordDef upsRecord );

/********************* PRIVATE **************************/

  private slots:

/**
 * Is activated when button ok is pressed.
 * Provede se pri stisknuti tlacitka ok.
 *
 * @since  0.1
 **/
  virtual void slotOk();


private:
/**
 * This class is inner class for showing items.
 * Add information about order number of UPS values.
 * Tato trida je vnorena trida pro zobrazeni polozek.
 * Pridava informaci o poradovem cisle UPS promennych.
 * @author Daniel Prynych
 * @short Item of listBox 
 *
 * @version 0.1
 */
    class KNutUpsBoxItem : public TQListBoxText
    {
    private:
    int m_ordVarCode;

    public:
    KNutUpsBoxItem ( TQListBox* listbox, const TQString & text=TQString(), const int ordVarCode = 0 ) :
                   TQListBoxText (listbox, text), m_ordVarCode (ordVarCode)  {};
    KNutUpsBoxItem ( TQListBox* listbox, const TQString & text, TQListBoxItem *after, const int ordVarCode = 0 ) :
                   TQListBoxText (listbox, text, after), m_ordVarCode (ordVarCode)  {};
    int getVarCode (void) const {return m_ordVarCode;};
    void putGetCode (const int ordVarCode) {m_ordVarCode = ordVarCode;};
//    TQString text () const {return TQListBoxItem::text();};
    };


  void moveToSelectedList (const int codeUpsVar);

  bool isExistSelectedItem  (const int codeUpsVar) const;


  bool addMember;   // true pokud se pridava polozka, false edit
  KNutUpsData* m_myUpsData; // Ups data object

  KLineEdit* m_lineEdit1;
  KLineEdit* m_lineEdit2;
  KLineEdit* m_lineEdit3;
  KLineEdit* m_lineEdit4;
  KLineEdit* m_lineEdit5;
  KLineEdit* m_lineEdit6;
  KLineEdit* m_lineEdit7;

  TQCheckBox* m_savePassword;

  TDEActionSelector* m_upsValueSelector;

};

#endif
