/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROCESSINGDIALOG_H
#define PROCESSINGDIALOG_H

#include <tqdialog.h>
#include <tdelibs_export.h>

class TQLayoutItem;

 /**
  * \brief A modal dialog header
  *
  * Internal use only
  *
  * @author Timothy Pearson <kb9vqf@pearsoncomputing.net>
  */
class TDEUI_EXPORT ProcessingDialogHeader : public TQWidget
{
	TQ_OBJECT
	
	public:
		ProcessingDialogHeader( TQWidget* parent );
		~ProcessingDialogHeader();
};

 /**
  * \brief A modal dialog
  *
  * This displays a special TDE modal dialog,
  * which is used to present noninterruptible
  * messages to the user.
  *
  * @author Timothy Pearson <kb9vqf@pearsoncomputing.net>
  */
class TQLabel;
class TDEUI_EXPORT ProcessingDialog : public TQWidget
{
	TQ_OBJECT
	
	public:
		ProcessingDialog( TQWidget* parent );
		~ProcessingDialog();
		
		void setStatusMessage(TQString message);
		void closeDialog();
	
	protected slots:
		void keepMeOnTop();
		void closeEvent(TQCloseEvent *e);
	
	private:
		TQTimer* m_keepOnTopTimer;
		TQLabel* m_statusLabel;
		bool m_allowClose;
};

#endif // PROCESSINGDIALOG_H
