/*
 * xine_part.h
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef XINEPART_H
#define XINEPART_H


#include <tdeparts/factory.h>

#include <tqtimer.h>

#include "kaffeinepart.h"
#include "xine_part_iface.h"

#define FORWARD_TIMER 0
#define BACKWARD_TIMER 1

class TQWidget;
class TQSlider;
class TQLabel;
class TQPushButton;
class MRL;
class KXineWidget;
class TQPoint;
class TDESelectAction;
class TDEToggleAction;
class Equalizer;
class VideoSettings;
class FilterDialog;
class PositionSlider;
class KProgressDialog;
class TDEPopupMenu;

/**
 * Kaffeine Part - xine based player part
 * @author Jürgen Kofler <kaffeine@gmx.net>
 *
 */
class XinePart : public KaffeinePart, public XinePartIface
{
	TQ_OBJECT
  
public:
	XinePart(TQWidget*, const char*, TQObject*, const char*, const TQStringList&);
	virtual ~XinePart();

	/*
	 *Reimplemented from KaffeinePart
	 */
	bool isPlaying();
	bool isPaused();

	bool hasChapters(); /* e.g. DVD */
	void playNextChapter();
	void playPreviousChapter();
	void setDVDChapter(uint chapter);

	bool hasVideo();
	TQString supportedExtensions();
	void* engine();
	uint volume() const; /* percent */
	uint position() const; /* percent */

	bool closeURL(); /* stops playback and shows kaffeine logo */
	static TDEAboutData* createAboutData();

	/*
	 * DCOP functions...
	 */
	int getContrast();
	void setContrast(int c);
	int getBrightness();
	void setBrightness(int b);
	void dvdMenuUp();
	void dvdMenuDown();
	void dvdMenuLeft();
	void dvdMenuRight();
	void dvdMenuSelect();
	void dvdMenuToggle();
	void aspectRatioAuto();
	void aspectRatio4_3();
	void aspectRatioAnamorphic();
	void aspectRatioSquare();
	void aspectRatioDVB();
	void zoomInX();
	void zoomOutX();
	void zoomInY();
	void zoomOutY();
	void zoomIn();
	void zoomOut();
	void zoomOff();
	TQString screenShot();
	void nextAudioChannel();
	void nextSubtitleChannel();
	void speedFaster();
	void speedSlower();

public slots:
	/*
	 * Reimplemented from KaffeinePart
	 */
	bool openURL(const MRL& mrl);
	void slotPrepareForFullscreen(bool);
	void slotPlay(bool forcePlay=false);
	void slotTogglePause(bool pauseLive=true);
	void slotSetVolume(uint); /* percent */
	void slotSetPosition(uint); /* percent */
	void slotPosPlusSmall();
	void slotPosMinusSmall();
	void slotSyncVolume();
	void slotStop();
	void slotMute(); /* toggle mute */

	void slotVolumeUp();
	void slotVolumeDown();
	void slotPosPlusMedium();
	void slotPosMinusMedium();
	void slotPosPlusLarge();
	void slotPosMinusLarge();
	void slotJumpIncrement(int);
	void slotDelaySubTitle();
	void slotAdvanceSubTitle();
	void slotAddSubtitle();
	void slotNextAudioChannel();
	void slotNextSubtitleChannel();
	/***************** Private ********************/

private slots:
	void slotFinalize();
	void slotTrackPlaying();
	void slotCheckMoved();
	void slotNext();
	void slotPrevious();
	void slotSaveStream();
	void slotChannelInfo(const TQStringList&, const TQStringList&, int, int);
	void slotSetSubtitle(int);
	void slotSetAudioChannel(int);
	void slotNewPosition(int, const TQTime&);
	void slotVolumeChanged(int);
	void slotPictureSettings();
	void slotEqualizer();
	void slotDeinterlaceQuality();
	void slotFilterDialog();
	void slotInfo();
	void slotToggleBroadcastSend();
	void slotBroadcastReceive();
	void slotJumpToPosition();
	void slotButtonTimerPressed();
	void slotButtonTimerReleased();
	void slotToggleOsdTimer();
	void slotScreenshot();
	void slotConfigXine();
	void slotError(const TQString&);
	void slotMessage(const TQString&);
	void slotStatus(const TQString&);
	void slotNewTitle();
	void slotNewLength();
	void slotNewFrameSize();
	void slotPlaybackFinished();
	void slotContextMenu(const TQPoint&);
	void slotDisableAllActions();
	void slotEnableAllActions();
	void slotEnablePlayActions();
	void slotCopyToClipboard();
	void slotLaunchExternally();
	void slotLaunchDelayed();
	void slotFastForward();
	void slotSlowMotion();
	void slotSetDVDTitle(const TQString&);
	void slotSetDVDChapter(const TQString&);
	void slotSetDVDAngle(const TQString&);
	void slotDVDMenuLeft();
	void slotDVDMenuRight();
	void slotDVDMenuUp();
	void slotDVDMenuDown();
	void slotDVDMenuSelect();
	void slotSetHue(int);
	void slotSetSaturation(int);
	void slotSetContrast(int);
	void slotSetBrightness(int);

private:
	void initActions();
	void initConnections();
	void loadConfig();
	void saveConfig();

private:
	TQPoint m_oldPosition;
	TQTimer m_posCheckTimer;
	TQTimer m_osdTimerEnabler;  /* Provide Long click on timer button */
	bool m_isOsdTimer;  /* Status of Osd Timer (on/off) */
	int m_timerDirection;  /* Counting Up or Down */
	int m_brightness, m_hue, m_contrast, m_saturation;

	MRL m_mrl;
	TQValueList<MRL> m_playlist;
	uint m_current;
	uint m_lastDeinterlaceQuality;
	TQString m_lastDeinterlacerConfig;
	uint m_broadcastPort;
	TQString m_broadcastAddress;

	TQSlider* m_volume;
	PositionSlider* m_position;
	TQPushButton* m_playTime;
	uint currentPosition;

	TDESelectAction* m_audioChannels;
	TDESelectAction* m_audioVisual;
	TDESelectAction* m_subtitles;
	TDESelectAction* m_dvdChapters;
	TDESelectAction* m_dvdTitles;
	TDESelectAction* m_dvdAngles;
	TDEToggleAction* m_deinterlaceEnabled;
	TDEToggleAction* m_broadcastSend;
	TDEToggleAction* m_pauseButton;

	KXineWidget* m_xine;
	VideoSettings* m_pictureSettings;
	Equalizer* m_equalizer;
	TQWidget* m_deinterlacerConfigWidget;
	FilterDialog* m_filterDialog;

	TDEPopupMenu* m_embeddedContext;

	/*  dvb  */
public:
	TQString TimeShiftFilename;

public slots:
	void slotDvbOpen( const TQString &filename, const TQString &chanName, int haveVideo );
	void getTimeShiftFilename( const TQString &filename );
	void requestForOSD( const TQString &text, int duration, int priority );
	void setDvbCurrentNext( const TQString &channelname, const TQStringList &list );

signals:
	void stopDvb();
	void playerPause();
	void dvbOSDHide();
};


#include <tqslider.h>

class VolumeSlider : public TQSlider
{

public:

	VolumeSlider();
	~VolumeSlider();

protected:

	void wheelEvent(TQWheelEvent* e);
	//bool eventFilter(TQObject *obj, TQEvent *ev);
};

#endif /* XINEPART_H */
